/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kudu;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kudu.KuduEndpoint;
import org.apache.camel.component.kudu.KuduUtils;
import org.apache.camel.support.DefaultProducer;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Delete;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.Update;
import org.apache.kudu.client.Upsert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KuduProducer.class);
    private final KuduEndpoint endpoint;

    public KuduProducer(KuduEndpoint endpoint) {
        super((Endpoint)endpoint);
        if (endpoint == null || endpoint.getKuduClient() == null) {
            throw new IllegalArgumentException("Can't create a producer when the database connection is null");
        }
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        String table = this.endpoint.getTableName();
        switch (this.endpoint.getOperation()) {
            case INSERT: {
                this.doInsert(exchange, table);
                break;
            }
            case DELETE: {
                this.doDelete(exchange, table);
                break;
            }
            case UPDATE: {
                this.doUpdate(exchange, table);
                break;
            }
            case UPSERT: {
                this.doUpsert(exchange, table);
                break;
            }
            case CREATE_TABLE: {
                this.doCreateTable(exchange, table);
                break;
            }
            case SCAN: {
                this.doScan(exchange, table);
                break;
            }
            default: {
                throw new IllegalArgumentException("The operation " + String.valueOf((Object)this.endpoint.getOperation()) + " is not supported");
            }
        }
    }

    private void doInsert(Exchange exchange, String tableName) throws KuduException {
        LOG.trace("Insert on table {}", (Object)tableName);
        KuduClient connection = this.endpoint.getKuduClient();
        KuduTable table = connection.openTable(tableName);
        Insert insert = table.newInsert();
        PartialRow row = insert.getRow();
        Map rows = (Map)exchange.getIn().getBody(Map.class);
        for (Map.Entry entry : rows.entrySet()) {
            String colName = entry.getKey().toString();
            Object value = entry.getValue();
            if (table.getSchema().getColumn(colName) == null) continue;
            row.addObject(colName, value);
        }
        connection.newSession().apply((Operation)insert);
    }

    private void doDelete(Exchange exchange, String tableName) throws KuduException {
        LOG.trace("Delete on table {}", (Object)tableName);
        KuduClient connection = this.endpoint.getKuduClient();
        KuduTable table = connection.openTable(tableName);
        Delete delete = table.newDelete();
        PartialRow row = delete.getRow();
        Map rows = (Map)exchange.getIn().getBody(Map.class);
        for (Map.Entry entry : rows.entrySet()) {
            String colName = entry.getKey().toString();
            Object value = entry.getValue();
            ColumnSchema column = table.getSchema().getColumn(colName);
            if (column == null || !column.isKey()) continue;
            row.addObject(colName, value);
        }
        connection.newSession().apply((Operation)delete);
    }

    private void doUpdate(Exchange exchange, String tableName) throws KuduException {
        LOG.trace("Update on table {}", (Object)tableName);
        KuduClient connection = this.endpoint.getKuduClient();
        KuduTable table = connection.openTable(tableName);
        Update update = table.newUpdate();
        PartialRow row = update.getRow();
        Map rows = (Map)exchange.getIn().getBody(Map.class);
        for (Map.Entry entry : rows.entrySet()) {
            String colName = entry.getKey().toString();
            Object value = entry.getValue();
            if (table.getSchema().getColumn(colName) == null) continue;
            row.addObject(colName, value);
        }
        connection.newSession().apply((Operation)update);
    }

    private void doUpsert(Exchange exchange, String tableName) throws KuduException {
        LOG.trace("Upsert on table {}", (Object)tableName);
        KuduClient connection = this.endpoint.getKuduClient();
        KuduTable table = connection.openTable(tableName);
        Upsert upsert = table.newUpsert();
        PartialRow row = upsert.getRow();
        Map rows = (Map)exchange.getIn().getBody(Map.class);
        for (Map.Entry entry : rows.entrySet()) {
            String colName = entry.getKey().toString();
            Object value = entry.getValue();
            if (table.getSchema().getColumn(colName) == null) continue;
            row.addObject(colName, value);
        }
        connection.newSession().apply((Operation)upsert);
    }

    private void doCreateTable(Exchange exchange, String tableName) throws KuduException {
        LOG.trace("Creating table {}", (Object)tableName);
        KuduClient connection = this.endpoint.getKuduClient();
        Schema schema = (Schema)exchange.getIn().getHeader("CamelKuduSchema");
        CreateTableOptions builder = (CreateTableOptions)exchange.getIn().getHeader("CamelKuduTableOptions");
        connection.createTable(tableName, schema, builder);
    }

    private void doScan(Exchange exchange, String tableName) throws KuduException {
        List columnNames = (List)exchange.getIn().getHeader("CamelKuduScanColumnNames");
        KuduPredicate predicate = (KuduPredicate)exchange.getIn().getHeader("CamelKuduScanPredicate");
        long limit = Optional.ofNullable((Long)exchange.getIn().getHeader("CamelKuduScanLimit")).orElse(-1L);
        exchange.getIn().setBody(KuduUtils.doScan(tableName, this.endpoint.getKuduClient(), columnNames, predicate, limit));
    }
}

