/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.events;

import io.fabric8.kubernetes.api.model.events.v1.Event;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesEventsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesEventsConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private EventsConsumerTask eventWatcher;

    public KubernetesEventsConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor((Object)this);
        this.eventWatcher = new EventsConsumerTask();
        this.executor.submit(this.eventWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Event Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.eventWatcher, this.eventWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class EventsConsumerTask
    implements Runnable {
        private Watch watch;

        EventsConsumerTask() {
        }

        @Override
        public void run() {
            FilterWatchListDeletable w;
            String namespace = KubernetesEventsConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace();
            String labelKey = KubernetesEventsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey();
            String labelValue = KubernetesEventsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue();
            String resourceName = KubernetesEventsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName();
            if (ObjectHelper.isEmpty((String)namespace)) {
                w = (FilterWatchListDeletable)KubernetesEventsConsumer.this.getEndpoint().getKubernetesClient().events().v1().events().inAnyNamespace();
                if (ObjectHelper.isNotEmpty((String)labelKey) && ObjectHelper.isNotEmpty((String)labelValue)) {
                    w = (FilterWatchListDeletable)w.withLabel(labelKey, labelValue);
                }
            } else {
                NonNamespaceOperation client = (NonNamespaceOperation)KubernetesEventsConsumer.this.getEndpoint().getKubernetesClient().events().v1().events().inNamespace(namespace);
                w = client;
                if (ObjectHelper.isNotEmpty((String)labelKey) && ObjectHelper.isNotEmpty((String)labelValue)) {
                    w = (FilterWatchListDeletable)client.withLabel(labelKey, labelValue);
                } else if (ObjectHelper.isNotEmpty((String)resourceName)) {
                    w = (FilterWatchListDeletable)client.withName(resourceName);
                }
            }
            this.watch = w.watch((Watcher)new Watcher<Event>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventReceived(Watcher.Action action, Event resource) {
                    Exchange exchange = KubernetesEventsConsumer.this.createExchange(false);
                    exchange.getIn().setBody((Object)resource);
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)action);
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesEventsConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesEventsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                    finally {
                        KubernetesEventsConsumer.this.releaseExchange(exchange, false);
                    }
                }

                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

