/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Component;
import org.apache.camel.component.kubernetes.AbstractKubernetesComponent;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

public abstract class AbstractKubernetesEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    @UriParam
    private KubernetesConfiguration configuration;
    private transient KubernetesClient client;

    protected AbstractKubernetesEndpoint(String uri, AbstractKubernetesComponent component, KubernetesConfiguration config) {
        super(uri, (Component)component);
        this.configuration = config;
    }

    public String getServiceUrl() {
        String answer = this.configuration.getMasterUrl();
        if (answer == null || answer.isEmpty() && this.client != null) {
            answer = this.client.getMasterUrl().toString();
        }
        return answer;
    }

    public String getServiceProtocol() {
        return "rest";
    }

    public KubernetesConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isSingleton() {
        return false;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.client = KubernetesHelper.getKubernetesClient(this.configuration);
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.client != null && this.configuration.getKubernetesClient() == null) {
            this.client.close();
        }
    }

    public ExecutorService createExecutor(Object source) {
        return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool(source, "KubernetesConsumer", this.configuration.getPoolSize());
    }

    public KubernetesClient getKubernetesClient() {
        return this.client;
    }

    public KubernetesConfiguration getKubernetesConfiguration() {
        return this.configuration;
    }
}

