/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.cluster.lock;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Set;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.kubernetes.cluster.LeaseResourceType;
import org.apache.camel.component.kubernetes.cluster.lock.LeaderInfo;
import org.apache.camel.component.kubernetes.cluster.lock.impl.ConfigMapLeaseResourceManager;
import org.apache.camel.component.kubernetes.cluster.lock.impl.NativeLeaseResourceManager;

public interface KubernetesLeaseResourceManager<T extends HasMetadata> {
    public static <S extends HasMetadata> KubernetesLeaseResourceManager<S> create(LeaseResourceType type) {
        switch (type) {
            case ConfigMap: {
                return new ConfigMapLeaseResourceManager();
            }
            case Lease: {
                return new NativeLeaseResourceManager();
            }
        }
        throw new RuntimeCamelException("Unsupported lease resource type " + String.valueOf((Object)type));
    }

    public LeaderInfo decodeLeaderInfo(T var1, Set<String> var2, String var3);

    public T fetchLeaseResource(KubernetesClient var1, String var2, String var3, String var4);

    public T optimisticDeleteLeaderInfo(KubernetesClient var1, T var2, String var3);

    public T optimisticAcquireLeadership(KubernetesClient var1, T var2, LeaderInfo var3);

    public T createNewLeaseResource(KubernetesClient var1, String var2, String var3, LeaderInfo var4);

    public T refreshLeaseRenewTime(KubernetesClient var1, T var2, int var3);
}

