/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kserve;

import inference.GRPCInferenceServiceGrpc;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.kserve.KServeComponent;
import org.apache.camel.component.kserve.KServeConfiguration;
import org.apache.camel.component.kserve.KServeConstants;
import org.apache.camel.component.kserve.KServeProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="4.10.0", scheme="kserve", title="KServe", syntax="kserve:api", producerOnly=true, category={Category.AI}, headersClass=KServeConstants.class)
public class KServeEndpoint
extends DefaultEndpoint {
    @UriPath(enums="infer,model/ready,model/metadata,server/ready,server/live,server/metadata", description="The KServe API")
    @Metadata(required=true)
    private final String api;
    @UriParam
    private KServeConfiguration configuration;
    private ManagedChannel channel;
    private GRPCInferenceServiceGrpc.GRPCInferenceServiceBlockingStub inferenceService;

    public KServeEndpoint(String uri, KServeComponent component, String path, KServeConfiguration configuration) {
        super(uri, (Component)component);
        this.api = path;
        this.configuration = configuration;
    }

    protected void doInit() throws Exception {
        super.doInit();
        ChannelCredentials credentials = this.configuration.getCredentials() != null ? this.configuration.getCredentials() : InsecureChannelCredentials.create();
        this.channel = Grpc.newChannelBuilder((String)this.configuration.getTarget(), (ChannelCredentials)credentials).build();
        this.inferenceService = GRPCInferenceServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    public void doStop() throws Exception {
        super.doStop();
        this.channel.shutdown();
    }

    public Producer createProducer() {
        return new KServeProducer(this);
    }

    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    public String getApi() {
        return this.api;
    }

    public KServeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KServeConfiguration configuration) {
        this.configuration = configuration;
    }

    public GRPCInferenceServiceGrpc.GRPCInferenceServiceBlockingStub getInferenceService() {
        return this.inferenceService;
    }
}

