/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative.ce;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.cloudevents.CloudEvent;
import org.apache.camel.cloudevents.CloudEvents;
import org.apache.camel.component.knative.KnativeEndpoint;
import org.apache.camel.component.knative.ce.AbstractCloudEventProcessor;
import org.apache.camel.component.knative.ce.CloudEventProcessor;
import org.apache.camel.component.knative.spi.KnativeResource;
import org.apache.camel.util.ObjectHelper;

public enum CloudEventProcessors implements CloudEventProcessor
{
    v1_0(new AbstractCloudEventProcessor((CloudEvent)CloudEvents.v1_0){

        @Override
        protected void decodeStructuredContent(Exchange exchange, Map<String, Object> content) {
            CloudEvent ce = this.cloudEvent();
            Message message = exchange.getIn();
            ObjectHelper.ifNotEmpty((Object)content.remove("data"), arg_0 -> ((Message)message).setBody(arg_0));
            ObjectHelper.ifNotEmpty((Object)content.remove(ce.mandatoryAttribute("CamelCloudEventDataContentType").json()), val -> message.setHeader("Content-Type", val));
            for (CloudEvent.Attribute attribute : ce.attributes()) {
                ObjectHelper.ifNotEmpty((Object)content.remove(attribute.json()), val -> message.setHeader(attribute.id(), val));
            }
            content.forEach((key, val) -> message.setHeader(key.toLowerCase(Locale.US), val));
        }
    }),
    v1_0_1(new AbstractCloudEventProcessor((CloudEvent)CloudEvents.v1_0_1){

        @Override
        protected void decodeStructuredContent(Exchange exchange, Map<String, Object> content) {
            CloudEvent ce = this.cloudEvent();
            Message message = exchange.getIn();
            ObjectHelper.ifNotEmpty((Object)content.remove("data"), arg_0 -> ((Message)message).setBody(arg_0));
            ObjectHelper.ifNotEmpty((Object)content.remove(ce.mandatoryAttribute("CamelCloudEventDataContentType").json()), val -> message.setHeader("Content-Type", val));
            for (CloudEvent.Attribute attribute : ce.attributes()) {
                ObjectHelper.ifNotEmpty((Object)content.remove(attribute.json()), val -> message.setHeader(attribute.id(), val));
            }
            content.forEach((key, val) -> message.setHeader(key.toLowerCase(Locale.US), val));
        }
    }),
    v1_0_2(new AbstractCloudEventProcessor((CloudEvent)CloudEvents.v1_0_2){

        @Override
        protected void decodeStructuredContent(Exchange exchange, Map<String, Object> content) {
            CloudEvent ce = this.cloudEvent();
            Message message = exchange.getIn();
            ObjectHelper.ifNotEmpty((Object)content.remove("data"), arg_0 -> ((Message)message).setBody(arg_0));
            ObjectHelper.ifNotEmpty((Object)content.remove(ce.mandatoryAttribute("CamelCloudEventDataContentType").json()), val -> message.setHeader("Content-Type", val));
            for (CloudEvent.Attribute attribute : ce.attributes()) {
                ObjectHelper.ifNotEmpty((Object)content.remove(attribute.json()), val -> message.setHeader(attribute.id(), val));
            }
            content.forEach((key, val) -> message.setHeader(key.toLowerCase(Locale.US), val));
        }
    });

    private final CloudEventProcessor instance;

    private CloudEventProcessors(CloudEventProcessor instance) {
        this.instance = instance;
    }

    @Override
    public CloudEvent cloudEvent() {
        return this.instance.cloudEvent();
    }

    @Override
    public Processor consumer(KnativeEndpoint endpoint, KnativeResource service) {
        return this.instance.consumer(endpoint, service);
    }

    @Override
    public Processor producer(KnativeEndpoint endpoint, KnativeResource service) {
        return this.instance.producer(endpoint, service);
    }

    public static CloudEventProcessor fromSpecVersion(String version) {
        for (CloudEventProcessors processor : CloudEventProcessors.values()) {
            if (!Objects.equals(processor.cloudEvent().version(), version)) continue;
            return processor;
        }
        throw new IllegalArgumentException("Unable to find an implementation for CloudEvents spec: " + version);
    }
}

