/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dsl.yaml.KameletRoutesBuilderLoader;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.main.util.SuggestSimilarHelper;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ReflectionHelper;

public class KnownKameletRoutesBuilderLoader
extends KameletRoutesBuilderLoader {
    private static final String CP = System.getProperty("java.class.path");

    public RouteBuilder doLoadRouteBuilder(Resource resource) throws Exception {
        if (!resource.exists()) {
            String loc = resource.getLocation();
            String name = FileUtil.onlyName((String)loc, (boolean)false);
            List<String> suggestion = SuggestSimilarHelper.didYouMean(this.findKameletNames(), name);
            if (suggestion != null && !suggestion.isEmpty()) {
                String s = String.join((CharSequence)", ", suggestion);
                throw new IllegalArgumentException("Cannot find Kamelet with name: " + name + ". Did you mean: " + s);
            }
        }
        return super.doLoadRouteBuilder(resource);
    }

    private List<String> findKameletNames() {
        Pattern pattern = Pattern.compile("camel-kamelets-(\\d+.\\d+.\\d+).jar", 32);
        Matcher matcher = pattern.matcher(CP);
        if (matcher.find() && matcher.groupCount() > 0) {
            String version = matcher.group(1);
            try {
                Class clazz;
                MavenDependencyDownloader downloader = (MavenDependencyDownloader)this.getCamelContext().hasService(MavenDependencyDownloader.class);
                if (!downloader.alreadyOnClasspath("org.apache.camel.kamelets", "camel-kamelets-catalog", version)) {
                    downloader.downloadDependency("org.apache.camel.kamelets", "camel-kamelets-catalog", version);
                }
                if ((clazz = this.getCamelContext().getClassResolver().resolveClass("org.apache.camel.kamelets.catalog.KameletsCatalog")) != null) {
                    Object catalog = this.getCamelContext().getInjector().newInstance(clazz);
                    Method m = ReflectionHelper.findMethod((Class)clazz, (String)"getKameletsName", (Class[])new Class[0]);
                    List names = (List)ObjectHelper.invokeMethod((Method)m, (Object)catalog, (Object[])new Object[0]);
                    return names;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }
}

