/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;

class DownloadThreadPool
extends ServiceSupport
implements CamelContextAware {
    private CamelContext camelContext;
    private volatile ExecutorService executorService;

    DownloadThreadPool() {
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void download(Logger log, Runnable task, String gav) {
        Future<?> future = this.executorService.submit(task);
        this.awaitCompletion(log, future, gav);
    }

    void awaitCompletion(Logger log, Future<?> future, String gav) {
        StopWatch watch = new StopWatch();
        boolean done = false;
        while (!done) {
            try {
                future.get(5000L, TimeUnit.MILLISECONDS);
                done = true;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                log.error("Error downloading: " + gav + " due: " + e.getMessage(), (Throwable)e);
                return;
            }
            if (done) continue;
            log.info("Downloading: {} (elapsed: {})", (Object)gav, (Object)TimeUtils.printDuration((long)watch.taken()));
        }
        long taken = watch.taken();
        String msg = "Downloaded: " + gav + " (took: " + TimeUtils.printDuration((long)taken, (boolean)true) + ")";
        if (taken < 1000L) {
            log.debug(msg);
        } else {
            log.info(msg);
        }
    }

    protected void doBuild() throws Exception {
        this.executorService = this.camelContext != null ? this.camelContext.getExecutorServiceManager().newCachedThreadPool((Object)this, "MavenDownload") : Executors.newCachedThreadPool();
    }

    protected void doShutdown() throws Exception {
        if (this.executorService != null && this.camelContext != null) {
            this.camelContext.getExecutorServiceManager().shutdown(this.executorService);
        } else if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }
}

