/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import org.apache.camel.CamelContext;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.download.MavenGav;
import org.apache.camel.spi.DependencyStrategy;

public class DependencyDownloaderStrategy
implements DependencyStrategy {
    private final CamelContext camelContext;
    private final DependencyDownloader downloader;

    public DependencyDownloaderStrategy(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.downloader = (DependencyDownloader)camelContext.hasService(DependencyDownloader.class);
    }

    public void onDependency(String dependency) {
        MavenGav gav = MavenGav.parseGav(dependency, this.camelContext.getVersion());
        if (!this.downloader.alreadyOnClasspath(gav.getGroupId(), gav.getArtifactId(), gav.getVersion())) {
            this.downloader.downloadDependency(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
        }
    }
}

