/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.impl.engine.DefaultLanguageResolver;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.util.SuggestSimilarHelper;
import org.apache.camel.spi.Language;
import org.apache.camel.tooling.model.LanguageModel;

public final class DependencyDownloaderLanguageResolver
extends DefaultLanguageResolver {
    private final CamelCatalog catalog = new DefaultCamelCatalog();
    private CamelContext camelContext;
    private final DependencyDownloader downloader;

    public DependencyDownloaderLanguageResolver(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.downloader = (DependencyDownloader)camelContext.hasService(DependencyDownloader.class);
    }

    public Language resolveLanguage(String name, CamelContext context) {
        List<String> suggestion;
        Language answer;
        LanguageModel model = this.catalog.languageModel(name);
        if (model != null) {
            this.downloadLoader(model.getArtifactId(), model.getVersion());
            if ("csimple".equals(name)) {
                this.downloadLoader("camel-csimple-joor", model.getVersion());
            }
        }
        if ((answer = super.resolveLanguage(name, context)) == null && (suggestion = SuggestSimilarHelper.didYouMean(this.catalog.findDataFormatNames(), name)) != null && !suggestion.isEmpty()) {
            String s = String.join((CharSequence)", ", suggestion);
            throw new IllegalArgumentException("Cannot find language with name: " + name + ". Did you mean: " + s);
        }
        return answer;
    }

    private void downloadLoader(String artifactId, String version) {
        if (!this.downloader.alreadyOnClasspath("org.apache.camel", artifactId, version)) {
            this.downloader.downloadDependency("org.apache.camel", artifactId, version);
        }
    }
}

