/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.stub.StubComponent;
import org.apache.camel.impl.engine.DefaultComponentResolver;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.http.VertxHttpServer;
import org.apache.camel.main.util.SuggestSimilarHelper;
import org.apache.camel.tooling.model.ComponentModel;

public final class DependencyDownloaderComponentResolver
extends DefaultComponentResolver {
    private static final String ACCEPTED_STUB_NAMES = "stub,bean,class,kamelet,rest,rest-api,platform-http,vertx-http";
    private final CamelCatalog catalog = new DefaultCamelCatalog();
    private final CamelContext camelContext;
    private final DependencyDownloader downloader;
    private final boolean stub;

    public DependencyDownloaderComponentResolver(CamelContext camelContext, boolean stub) {
        this.camelContext = camelContext;
        this.downloader = (DependencyDownloader)camelContext.hasService(DependencyDownloader.class);
        this.stub = stub;
    }

    public Component resolveComponent(String name, CamelContext context) {
        List<String> suggestion;
        boolean accept;
        ComponentModel model = this.catalog.componentModel(name);
        if (model != null && !this.downloader.alreadyOnClasspath(model.getGroupId(), model.getArtifactId(), model.getVersion())) {
            this.downloader.downloadDependency(model.getGroupId(), model.getArtifactId(), model.getVersion());
        }
        Component answer = (accept = this.accept(name)) ? super.resolveComponent(name, context) : super.resolveComponent("stub", context);
        if (this.stub && answer instanceof StubComponent) {
            StubComponent sc = (StubComponent)answer;
            sc.setShadow(true);
        }
        if (answer instanceof PlatformHttpComponent) {
            VertxHttpServer.setPlatformHttpComponent((PlatformHttpComponent)answer);
            VertxHttpServer.registerServer(this.camelContext, this.stub);
        }
        if (answer == null && (suggestion = SuggestSimilarHelper.didYouMean(this.catalog.findComponentNames(), name)) != null && !suggestion.isEmpty()) {
            String s = String.join((CharSequence)", ", suggestion);
            throw new IllegalArgumentException("Cannot find component with name: " + name + ". Did you mean: " + s);
        }
        return answer;
    }

    private boolean accept(String name) {
        if (!this.stub) {
            return true;
        }
        return ACCEPTED_STUB_NAMES.contains(name);
    }
}

