/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.main.download.DownloadException;

public class DependencyDownloaderClassLoader
extends URLClassLoader {
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];

    public DependencyDownloaderClassLoader(ClassLoader parent) {
        super(EMPTY_URL_ARRAY, parent);
    }

    public void addFile(File file) {
        try {
            super.addURL(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new DownloadException("Error adding JAR to classloader: " + file, e);
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return super.loadClass(name);
    }

    public List<String> getDownloaded() {
        return Arrays.stream(this.getURLs()).map(URL::getFile).collect(Collectors.toList());
    }
}

