/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesFunctionResolver;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.main.MainCommandLineSupport;
import org.apache.camel.main.MainRegistry;
import org.apache.camel.main.download.AutoConfigureDownloadListener;
import org.apache.camel.main.download.BasePackageScanDownloadListener;
import org.apache.camel.main.download.CircuitBreakerDownloader;
import org.apache.camel.main.download.CommandLineDependencyDownloader;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.main.download.DependencyDownloaderClassResolver;
import org.apache.camel.main.download.DependencyDownloaderComponentResolver;
import org.apache.camel.main.download.DependencyDownloaderDataFormatResolver;
import org.apache.camel.main.download.DependencyDownloaderKamelet;
import org.apache.camel.main.download.DependencyDownloaderLanguageResolver;
import org.apache.camel.main.download.DependencyDownloaderPropertiesFunctionResolver;
import org.apache.camel.main.download.DependencyDownloaderPropertyBindingListener;
import org.apache.camel.main.download.DependencyDownloaderResourceLoader;
import org.apache.camel.main.download.DependencyDownloaderRoutesLoader;
import org.apache.camel.main.download.DependencyDownloaderStrategy;
import org.apache.camel.main.download.DependencyDownloaderUriFactoryResolver;
import org.apache.camel.main.download.DownloadListener;
import org.apache.camel.main.download.DownloadModelineParser;
import org.apache.camel.main.download.KameletMainInjector;
import org.apache.camel.main.download.KnownDependenciesResolver;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.main.download.TypeConverterLoaderDownloadListener;
import org.apache.camel.main.http.VertxHttpServer;
import org.apache.camel.main.injection.AnnotationDependencyInjection;
import org.apache.camel.main.util.ExtraFilesClassLoader;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.CliConnector;
import org.apache.camel.spi.CliConnectorFactory;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.UriFactoryResolver;
import org.apache.camel.startup.jfr.FlightRecorderStartupStepRecorder;
import org.apache.camel.support.service.ServiceHelper;

public class KameletMain
extends MainCommandLineSupport {
    public static final String DEFAULT_KAMELETS_LOCATION = "classpath:/kamelets,github:apache:camel-kamelets/kamelets";
    protected final MainRegistry registry = new MainRegistry();
    private boolean download = true;
    private String repos;
    private boolean fresh;
    private String mavenSettings;
    private String mavenSettingsSecurity;
    private boolean stub;
    private DownloadListener downloadListener;
    private DependencyDownloaderClassLoader classLoader;

    public KameletMain() {
        this.configureInitialProperties(DEFAULT_KAMELETS_LOCATION);
    }

    public KameletMain(String overrides) {
        Objects.requireNonNull(overrides);
        String locations = overrides + ",classpath:/kamelets,github:apache:camel-kamelets/kamelets";
        this.configureInitialProperties(locations);
    }

    public static void main(String ... args) throws Exception {
        KameletMain main = new KameletMain();
        int code = main.run(args);
        if (code != 0) {
            System.exit(code);
        }
    }

    public void bind(String name, Object bean) {
        this.registry.bind(name, bean);
    }

    public Object lookup(String name) {
        return this.registry.lookupByName(name);
    }

    public <T> T lookup(String name, Class<T> type) {
        return (T)this.registry.lookupByNameAndType(name, type);
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.registry.findByTypeWithName(type);
    }

    public boolean isDownload() {
        return this.download;
    }

    public void setDownload(boolean download) {
        this.download = download;
    }

    public String getRepos() {
        return this.repos;
    }

    public void setRepos(String repos) {
        this.repos = repos;
    }

    public boolean isFresh() {
        return this.fresh;
    }

    public void setFresh(boolean fresh) {
        this.fresh = fresh;
    }

    public boolean isStub() {
        return this.stub;
    }

    public void setMavenSettings(String mavenSettings) {
        this.mavenSettings = mavenSettings;
    }

    public String getMavenSettings() {
        return this.mavenSettings;
    }

    public void setMavenSettingsSecurity(String mavenSettingsSecurity) {
        this.mavenSettingsSecurity = mavenSettingsSecurity;
    }

    public String getMavenSettingsSecurity() {
        return this.mavenSettingsSecurity;
    }

    public void setStub(boolean stub) {
        this.stub = stub;
    }

    public DownloadListener getDownloadListener() {
        return this.downloadListener;
    }

    public void setDownloadListener(DownloadListener downloadListener) {
        this.downloadListener = downloadListener;
    }

    public void showOptionsHeader() {
        System.out.println("Apache Camel (KameletMain) takes the following options");
        System.out.println();
    }

    protected void addInitialOptions() {
        this.addOption(new MainCommandLineSupport.Option("h", "help", "Displays the help screen"){

            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                KameletMain.this.showOptions();
                KameletMain.this.completed();
            }
        });
        this.addOption((MainCommandLineSupport.Option)new MainCommandLineSupport.ParameterOption("download", "download", "Whether to allow automatic downloaded JAR dependencies, over the internet.", "download"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                if (arg.equals("-download")) {
                    KameletMain.this.setDownload("true".equalsIgnoreCase(parameter));
                }
            }
        });
        this.addOption((MainCommandLineSupport.Option)new MainCommandLineSupport.ParameterOption("repos", "repositories", "Additional maven repositories for download on-demand.", "repos"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                if (arg.equals("-repos")) {
                    KameletMain.this.setRepos(parameter);
                }
            }
        });
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.initCamelContext();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getCamelContext() != null) {
            try {
                this.getCamelContext().start();
            }
            finally {
                if (this.getCamelContext().isVetoStarted()) {
                    this.completed();
                }
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.getCamelContext() != null) {
            this.getCamelContext().stop();
        }
    }

    protected ProducerTemplate findOrCreateCamelTemplate() {
        if (this.getCamelContext() != null) {
            return this.getCamelContext().createProducerTemplate();
        }
        return null;
    }

    protected CamelContext createCamelContext() {
        boolean console;
        Object port;
        CliConnectorFactory ccf;
        String info;
        DefaultCamelContext answer = new DefaultCamelContext(false);
        answer.setLogJvmUptime(true);
        if (this.download) {
            ClassLoader dynamicCL = this.createApplicationContextClassLoader();
            answer.setApplicationContextClassLoader(dynamicCL);
            answer.getPackageScanClassResolver().addClassLoader(dynamicCL);
            answer.getPackageScanResourceResolver().addClassLoader(dynamicCL);
            MavenDependencyDownloader downloader = new MavenDependencyDownloader();
            downloader.setClassLoader(dynamicCL);
            downloader.setCamelContext((CamelContext)answer);
            downloader.setRepos(this.repos);
            downloader.setFresh(this.fresh);
            downloader.setMavenSettings(this.mavenSettings);
            downloader.setMavenSettingsSecurity(this.mavenSettingsSecurity);
            if (this.downloadListener != null) {
                downloader.addDownloadListener(this.downloadListener);
            }
            downloader.addDownloadListener(new AutoConfigureDownloadListener());
            downloader.addArtifactDownloadListener(new TypeConverterLoaderDownloadListener());
            downloader.addArtifactDownloadListener(new BasePackageScanDownloadListener());
            try {
                ((ExtendedCamelContext)answer.adapt(ExtendedCamelContext.class)).addService((Object)downloader);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
            CircuitBreakerDownloader.registerDownloadReifiers();
        }
        if (this.stub) {
            this.mainConfigurationProperties.setAutowiredEnabled(false);
            this.mainConfigurationProperties.setAutoConfigurationFailFast(false);
        }
        if ((info = this.startupInfo()) != null) {
            LOG.info(info);
        }
        answer.setRegistry((Registry)this.registry);
        answer.setLoadHealthChecks(Boolean.valueOf(true));
        AnnotationDependencyInjection.initAnnotationBasedDependencyInjection((CamelContext)answer);
        if (!this.stub && answer.hasService(CliConnector.class) == null && (ccf = answer.getCliConnectorFactory()) != null && ccf.isEnabled()) {
            CliConnector connector = ccf.createConnector();
            try {
                answer.addService((Object)connector, true);
                ServiceHelper.startService((Object)connector);
            }
            catch (Exception e) {
                LOG.warn("Cannot start camel-cli-connector due: {}. This integration cannot be managed by Camel CLI.", (Object)e.getMessage());
            }
        }
        if ((port = this.getInitialProperties().get("camel.jbang.platform-http.port")) != null) {
            VertxHttpServer.registerServer((CamelContext)answer, Integer.parseInt(port.toString()), this.stub);
        }
        if ((console = "true".equals(this.getInitialProperties().get("camel.jbang.console"))) && port == null) {
            VertxHttpServer.registerServer((CamelContext)answer, 8080, this.stub);
        }
        if (console) {
            VertxHttpServer.registerConsole((CamelContext)answer);
        }
        this.configure().withDevConsoleEnabled(true);
        this.configure().withCamelEventsTimestampEnabled(true);
        this.configure().withLoadHealthChecks(true);
        this.configure().withModeline(true);
        this.configure().withLoadStatisticsEnabled(true);
        this.configure().withMessageHistory(true);
        this.configure().withInflightRepositoryBrowseEnabled(true);
        this.configure().withEndpointRuntimeStatisticsEnabled(true);
        this.configure().withJmxManagementStatisticsLevel(ManagementStatisticsLevel.Extended);
        this.configure().withShutdownLogInflightExchangesOnTimeout(false);
        this.configure().withShutdownTimeout(10);
        boolean health = "true".equals(this.getInitialProperties().get("camel.jbang.health"));
        if (health && port == null) {
            VertxHttpServer.registerServer((CamelContext)answer, 8080, this.stub);
        }
        if (health) {
            VertxHttpServer.registerHealthCheck((CamelContext)answer);
        }
        Object jfr = this.getInitialProperties().get("camel.jbang.jfr");
        Object jfrProfile = this.getInitialProperties().get("camel.jbang.jfr-profile");
        if ("jfr".equals(jfr) || jfrProfile != null) {
            FlightRecorderStartupStepRecorder recorder = new FlightRecorderStartupStepRecorder();
            recorder.setRecording(true);
            if (jfrProfile != null) {
                recorder.setRecordingProfile(jfrProfile.toString());
            }
            answer.setStartupStepRecorder((StartupStepRecorder)recorder);
        }
        try {
            Object dependencies = this.getInitialProperties().get("camel.jbang.dependencies");
            if (dependencies != null) {
                answer.addService((Object)new CommandLineDependencyDownloader((CamelContext)answer, dependencies.toString()));
            }
            KnownDependenciesResolver known = new KnownDependenciesResolver((CamelContext)answer);
            known.loadKnownDependencies();
            DependencyDownloaderPropertyBindingListener listener = new DependencyDownloaderPropertyBindingListener((CamelContext)answer, known);
            answer.getRegistry().bind(DependencyDownloaderPropertyBindingListener.class.getSimpleName(), (Object)listener);
            answer.getRegistry().bind(DependencyDownloaderStrategy.class.getSimpleName(), (Object)new DependencyDownloaderStrategy((CamelContext)answer));
            answer.setClassResolver((ClassResolver)new DependencyDownloaderClassResolver((CamelContext)answer, known));
            answer.setComponentResolver((ComponentResolver)new DependencyDownloaderComponentResolver((CamelContext)answer, this.stub));
            answer.setUriFactoryResolver((UriFactoryResolver)new DependencyDownloaderUriFactoryResolver((CamelContext)answer));
            answer.setDataFormatResolver((DataFormatResolver)new DependencyDownloaderDataFormatResolver((CamelContext)answer));
            answer.setLanguageResolver((LanguageResolver)new DependencyDownloaderLanguageResolver((CamelContext)answer));
            answer.setResourceLoader((ResourceLoader)new DependencyDownloaderResourceLoader((CamelContext)answer));
            answer.setInjector((Injector)new KameletMainInjector(answer.getInjector(), this.stub));
            answer.addService((Object)new DependencyDownloaderKamelet((CamelContext)answer));
            answer.getRegistry().bind(DownloadModelineParser.class.getSimpleName(), (Object)new DownloadModelineParser((CamelContext)answer));
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
        return answer;
    }

    protected void configurePropertiesService(CamelContext camelContext) throws Exception {
        super.configurePropertiesService(camelContext);
        if (this.download) {
            PropertiesComponent pc = (PropertiesComponent)camelContext.getPropertiesComponent();
            pc.setPropertiesFunctionResolver((PropertiesFunctionResolver)new DependencyDownloaderPropertiesFunctionResolver(camelContext));
        }
    }

    protected void autoconfigure(CamelContext camelContext) throws Exception {
        camelContext.setApplicationContextClassLoader(this.createApplicationContextClassLoader());
        super.autoconfigure(camelContext);
    }

    protected ClassLoader createApplicationContextClassLoader() {
        if (this.classLoader == null) {
            ClassLoader parentCL = KameletMain.class.getClassLoader();
            String cpFiles = this.getInitialProperties().getProperty("camel.jbang.classpathFiles");
            if (cpFiles != null) {
                parentCL = new ExtraFilesClassLoader(parentCL, cpFiles.split(","));
                LOG.info("Additional files added to classpath: {}", (Object)cpFiles);
            }
            this.classLoader = new DependencyDownloaderClassLoader(parentCL);
        }
        return this.classLoader;
    }

    protected void configureRoutesLoader(CamelContext camelContext) {
        if (this.download) {
            ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).setRoutesLoader((RoutesLoader)new DependencyDownloaderRoutesLoader(camelContext, this.configure()));
        } else {
            super.configureRoutesLoader(camelContext);
        }
    }

    protected void configureInitialProperties(String location) {
        this.addInitialProperty("camel.component.kamelet.location", location);
        this.addInitialProperty("camel.component.rest.consumerComponentName", "platform-http");
        this.addInitialProperty("camel.component.rest.producerComponentName", "vertx-http");
    }

    protected String startupInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("Using Java ").append(System.getProperty("java.version"));
        String pid = KameletMain.getPid();
        if (pid != null) {
            sb.append(" with PID ").append(pid);
        }
        sb.append(". Started by ").append(System.getProperty("user.name"));
        sb.append(" in ").append(System.getProperty("user.dir"));
        return sb.toString();
    }

    private static String getPid() {
        try {
            return "" + ProcessHandle.current().pid();
        }
        catch (Throwable e) {
            return null;
        }
    }
}

