/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer;

import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.consumer.AsyncCommitManager;
import org.apache.camel.component.kafka.consumer.CommitManager;
import org.apache.camel.component.kafka.consumer.CommitToOffsetManager;
import org.apache.camel.component.kafka.consumer.DefaultKafkaManualAsyncCommitFactory;
import org.apache.camel.component.kafka.consumer.DefaultKafkaManualCommitFactory;
import org.apache.camel.component.kafka.consumer.KafkaManualCommitFactory;
import org.apache.camel.component.kafka.consumer.NoopCommitManager;
import org.apache.camel.component.kafka.consumer.SyncCommitManager;
import org.apache.kafka.clients.consumer.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommitManagers {
    private static final Logger LOG = LoggerFactory.getLogger(CommitManagers.class);

    private CommitManagers() {
    }

    public static CommitManager createCommitManager(Consumer<?, ?> consumer, KafkaConsumer kafkaConsumer, String threadId, String printableTopic) {
        KafkaConfiguration configuration = kafkaConsumer.getEndpoint().getConfiguration();
        if (configuration.isAllowManualCommit()) {
            LOG.debug("Allowing manual commit management");
            KafkaManualCommitFactory manualCommitFactory = kafkaConsumer.getEndpoint().getKafkaManualCommitFactory();
            if (manualCommitFactory instanceof DefaultKafkaManualAsyncCommitFactory) {
                LOG.debug("Using an async commit manager for manual commit management");
                return new AsyncCommitManager(consumer, kafkaConsumer, threadId, printableTopic);
            }
            if (manualCommitFactory instanceof DefaultKafkaManualCommitFactory) {
                LOG.debug("Using a sync commit manager for manual commit management");
                return new SyncCommitManager(consumer, kafkaConsumer, threadId, printableTopic);
            }
            LOG.debug("Using an NO-OP commit manager for manual commit management");
            return new NoopCommitManager(consumer, kafkaConsumer, threadId, printableTopic);
        }
        if (configuration.getOffsetRepository() != null) {
            LOG.debug("Using a commit-to-offset manager for commit management");
            return new CommitToOffsetManager(consumer, kafkaConsumer, threadId, printableTopic);
        }
        if (configuration.isBatching()) {
            LOG.debug("Using an async commit manager for auto commit management with batch processing");
            return new AsyncCommitManager(consumer, kafkaConsumer, threadId, printableTopic);
        }
        LOG.debug("Using a NO-OP commit manager with auto-commit enabled on the Kafka consumer");
        return new NoopCommitManager(consumer, kafkaConsumer, threadId, printableTopic);
    }
}

