/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jte;

import gg.jte.TemplateEngine;
import gg.jte.TemplateOutput;
import gg.jte.output.StringOutput;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.jte.JteCodeResolver;
import org.apache.camel.component.jte.JteComponent;
import org.apache.camel.component.jte.JteConstants;
import org.apache.camel.component.jte.Model;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

@UriEndpoint(firstVersion="4.4.0", scheme="jte", title="JTE", syntax="jte:resourceUri", remote=false, producerOnly=true, category={Category.TRANSFORMATION}, headersClass=JteConstants.class)
public class JteEndpoint
extends ResourceEndpoint {
    @UriParam
    private boolean allowTemplateFromHeader;

    public JteEndpoint() {
    }

    public JteEndpoint(String endpointUri, Component component, String resourceUri) {
        super(endpointUri, component, resourceUri);
    }

    public boolean isRemote() {
        return false;
    }

    public void clearContentCache() {
        super.clearContentCache();
        TemplateEngine template = this.getComponent().getTemplateEngine();
        if (template != null) {
            template.clearCache();
            template.cleanAll();
        }
    }

    public JteComponent getComponent() {
        return (JteComponent)super.getComponent();
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public JteEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        this.log.debug("Getting endpoint with URI: {}", (Object)newUri);
        return (JteEndpoint)this.getCamelContext().getEndpoint(newUri, JteEndpoint.class);
    }

    protected void onExchange(Exchange exchange) throws Exception {
        String newResourceUri;
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        if (this.allowTemplateFromHeader && (newResourceUri = (String)exchange.getIn().getHeader("CamelJteResourceUri", String.class)) != null) {
            exchange.getIn().removeHeader("CamelJteResourceUri");
            this.log.debug("{} set to {} creating new endpoint to handle exchange", (Object)"CamelJteResourceUri", (Object)newResourceUri);
            JteEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
            newEndpoint.onExchange(exchange);
            return;
        }
        JteCodeResolver codeResolver = this.getComponent().getCodeResolver();
        String name = this.getResourceUri();
        if (this.allowTemplateFromHeader) {
            String content = (String)exchange.getIn().getHeader("CamelJteTemplate", String.class);
            if (content != null) {
                exchange.getIn().removeHeader("CamelJteTemplate");
                if (codeResolver != null) {
                    name = exchange.getExchangeId();
                    codeResolver.addTemplateFromHeader(name, content);
                }
            }
        } else if (ResourceHelper.hasScheme((String)name)) {
            String uri = StringHelper.after((String)name, (String)":");
            name = StringHelper.before((String)name, (String)":");
            codeResolver.addPathMapping(name, uri);
        }
        Object dataModel = null;
        if (this.allowTemplateFromHeader) {
            dataModel = exchange.getIn().getHeader("CamelJteDataModel", Object.class);
        }
        if (dataModel == null) {
            Model model = new Model(this.getCamelContext());
            model.body = exchange.getMessage().getBody();
            model.headers = exchange.getMessage().getHeaders();
            if (this.isAllowContextMapAll()) {
                model.exchange = exchange;
            }
            dataModel = model;
        }
        TemplateEngine template = this.getComponent().getTemplateEngine();
        StringOutput buffer = new StringOutput();
        template.render(name, dataModel, (TemplateOutput)buffer);
        String s = buffer.toString();
        s = s.trim();
        ExchangeHelper.setInOutBodyPatternAware((Exchange)exchange, (Object)s);
    }
}

