/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class Jt400EndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":userID:password@systemName/QSYS.LIB/objectPath.type";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Map<String, String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "jt400".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "userID", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "password", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "systemName", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "objectPath", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "type", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Map<String, String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(39);
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("bridgeErrorHandler");
        props.add("ccsid");
        props.add("dataQueueCcsid");
        props.add("delay");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("format");
        props.add("greedy");
        props.add("guiAvailable");
        props.add("initialDelay");
        props.add("keyed");
        props.add("lazyStartProducer");
        props.add("messageAction");
        props.add("objectPath");
        props.add("outputFieldsIdxArray");
        props.add("outputFieldsLengthArray");
        props.add("password");
        props.add("pollStrategy");
        props.add("procedureName");
        props.add("readTimeout");
        props.add("repeatCount");
        props.add("runLoggingLevel");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("searchKey");
        props.add("searchType");
        props.add("secured");
        props.add("sendEmptyMessageWhenIdle");
        props.add("sendingReply");
        props.add("startScheduler");
        props.add("systemName");
        props.add("timeUnit");
        props.add("type");
        props.add("useFixedDelay");
        props.add("userID");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("userID");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashMap<String, String> prefixes = new HashMap<String, String>(1);
        prefixes.put("schedulerProperties", "scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableMap(prefixes);
    }
}

