/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.MessageQueue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jt400.Jt400Endpoint;
import org.apache.camel.component.jt400.Jt400MsgQueueService;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class Jt400MsgQueueProducer
extends DefaultProducer {
    private final Jt400Endpoint endpoint;

    protected Jt400MsgQueueProducer(Jt400Endpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        try (Jt400MsgQueueService queueService = new Jt400MsgQueueService(this.endpoint);){
            queueService.start();
            this.process(queueService.getMsgQueue(), exchange);
        }
    }

    private void process(MessageQueue queue, Exchange exchange) throws Exception {
        String msgText = (String)exchange.getIn().getBody(String.class);
        byte[] messageKey = (byte[])exchange.getIn().getHeader("CamelJt400MessageReplyToKey", byte[].class);
        if (ObjectHelper.isNotEmpty((Object)messageKey) && ObjectHelper.isNotEmpty((String)msgText)) {
            queue.reply(messageKey, msgText);
        } else {
            queue.sendInformational(msgText);
        }
    }
}

