/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath;

import java.io.CharConversionException;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class JsonStream
extends FilterInputStream {
    private static final byte[] BOM_UTF_32BE = new byte[]{0, 0, -2, -1};
    private static final byte[] BOM_UTF_32LE = new byte[]{-1, -2, 0, 0};
    private static final byte[] BOM_UTF_32_2143 = new byte[]{0, 0, -1, -2};
    private static final byte[] BOM_UTF_32_3412 = new byte[]{-2, -1, 0, 0};
    private static final byte[] BOM_UTF_16BE = new byte[]{-2, -1};
    private static final byte[] BOM_UTF_16LE = new byte[]{-1, -2};
    private static final byte[] BOM_UTF_8 = new byte[]{-17, -69, -65};
    private final byte[] fourByteBuffer = new byte[4];
    private int inputIndex;
    private int inputEnd;
    private final Charset encoding;

    public JsonStream(InputStream in) throws IOException {
        super(in);
        if (in == null) {
            throw new IllegalArgumentException("input stream is null");
        }
        this.inputIndex = 0;
        this.inputEnd = 0;
        Charset enc = null;
        if (this.loadAtLeast(4)) {
            enc = this.getEncodingFromBOM();
            if (enc == null && (enc = this.getUTF32EncodingFromNullPattern()) == null) {
                enc = this.getUTF16EncodingFromNullPattern();
            }
        } else if (this.loadAtLeast(2)) {
            enc = this.getUTF16EncodingFromNullPattern();
        }
        if (enc == null) {
            enc = StandardCharsets.UTF_8;
        }
        this.encoding = enc;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    private boolean loadAtLeast(int minimum) throws IOException {
        int count;
        for (int received = this.inputEnd - this.inputIndex; received < minimum; received += count) {
            count = this.in.read(this.fourByteBuffer, this.inputEnd, this.fourByteBuffer.length - this.inputEnd);
            if (count < 1) {
                return false;
            }
            this.inputEnd += count;
        }
        return true;
    }

    private Charset getEncodingFromBOM() throws IOException {
        if (Arrays.equals(this.fourByteBuffer, BOM_UTF_32BE)) {
            this.inputIndex = 4;
            return Charset.forName("UTF-32BE");
        }
        if (Arrays.equals(this.fourByteBuffer, BOM_UTF_32LE)) {
            this.inputIndex = 4;
            return Charset.forName("UTF-32LE");
        }
        if (Arrays.equals(this.fourByteBuffer, BOM_UTF_32_2143)) {
            throw this.getExceptionUnsupportedUCS4("2143");
        }
        if (Arrays.equals(this.fourByteBuffer, BOM_UTF_32_3412)) {
            throw this.getExceptionUnsupportedUCS4("3412");
        }
        byte[] firstTwoBytes = Arrays.copyOf(this.fourByteBuffer, 2);
        if (Arrays.equals(firstTwoBytes, BOM_UTF_16BE)) {
            this.inputIndex = 2;
            return StandardCharsets.UTF_16BE;
        }
        if (Arrays.equals(firstTwoBytes, BOM_UTF_16LE)) {
            this.inputIndex = 2;
            return StandardCharsets.UTF_16LE;
        }
        byte[] firstThreeBytes = Arrays.copyOf(this.fourByteBuffer, 3);
        if (Arrays.equals(firstThreeBytes, BOM_UTF_8)) {
            this.inputIndex = 3;
            return StandardCharsets.UTF_8;
        }
        return null;
    }

    private Charset getUTF32EncodingFromNullPattern() throws IOException {
        if (this.fourByteBuffer[0] == 0 && this.fourByteBuffer[1] == 0 && this.fourByteBuffer[2] == 0) {
            return Charset.forName("UTF-32BE");
        }
        if (this.fourByteBuffer[1] == 0 && this.fourByteBuffer[2] == 0 && this.fourByteBuffer[3] == 0) {
            return Charset.forName("UTF-32LE");
        }
        if (this.fourByteBuffer[0] == 0 && this.fourByteBuffer[2] == 0 && this.fourByteBuffer[3] == 0) {
            throw this.getExceptionUnsupportedUCS4("3412");
        }
        if (this.fourByteBuffer[0] == 0 && this.fourByteBuffer[1] == 0 && this.fourByteBuffer[3] == 0) {
            throw this.getExceptionUnsupportedUCS4("2143");
        }
        return null;
    }

    private Charset getUTF16EncodingFromNullPattern() {
        if (this.fourByteBuffer[0] == 0) {
            return StandardCharsets.UTF_16BE;
        }
        if (this.fourByteBuffer[1] == 0) {
            return StandardCharsets.UTF_16LE;
        }
        return null;
    }

    private CharConversionException getExceptionUnsupportedUCS4(String type) {
        return new CharConversionException("Unsupported UCS-4 endianness (" + type + ") detected");
    }

    @Override
    public int read() throws IOException {
        if (this.inputIndex < this.inputEnd) {
            byte result = this.fourByteBuffer[this.inputIndex];
            ++this.inputIndex;
            return result;
        }
        try {
            return this.in.read();
        }
        catch (EOFException ex) {
            return -1;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.inputIndex < this.inputEnd) {
            int minimum = Math.min(b.length, this.inputEnd - this.inputIndex);
            for (int i = 0; i < minimum; ++i) {
                b[i] = this.fourByteBuffer[this.inputIndex];
                ++this.inputIndex;
            }
            int rest = b.length - minimum;
            if (rest == 0) {
                return minimum;
            }
            try {
                int additionalRead = this.in.read(b, minimum, rest);
                if (additionalRead < 0) {
                    return minimum;
                }
                return minimum + additionalRead;
            }
            catch (EOFException ex) {
                return minimum;
            }
        }
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.inputIndex < this.inputEnd) {
            int minimum = Math.min(b.length, this.inputEnd - this.inputIndex);
            for (int i = 0; i < minimum; ++i) {
                b[off + i] = this.fourByteBuffer[this.inputIndex];
                ++this.inputIndex;
            }
            int rest = b.length - minimum;
            if (rest == 0) {
                return minimum;
            }
            try {
                int additionalRead = this.in.read(b, minimum + off, rest);
                if (additionalRead < 0) {
                    return minimum;
                }
                return minimum + additionalRead;
            }
            catch (EOFException ex) {
                return minimum;
            }
        }
        try {
            return this.in.read(b, off, len);
        }
        catch (EOFException ex) {
            return -1;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.inputIndex < this.inputEnd) {
            long minimum = Math.min(n, (long)this.inputEnd - (long)this.inputIndex);
            int i = 0;
            while ((long)i < minimum) {
                ++this.inputIndex;
                ++i;
            }
            long rest = n - minimum;
            if (rest == 0L) {
                return minimum;
            }
            long additionalSkipped = this.in.skip(rest);
            return additionalSkipped + minimum;
        }
        return this.in.skip(n);
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

