/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsonvalidator;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jsonvalidator.JsonValidatorEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="json-validator")
public class JsonValidatorComponent
extends DefaultComponent {
    @Metadata(defaultValue="true", description="Sets whether to use resource content cache or not")
    private boolean contentCache = true;
    @Metadata(defaultValue="true")
    private boolean useDefaultObjectMapper = true;
    @Metadata(label="advanced")
    private String objectMapper;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        JsonValidatorEndpoint endpoint = new JsonValidatorEndpoint(uri, (Component)this, remaining);
        if (this.objectMapper != null) {
            ObjectMapper om = (ObjectMapper)CamelContextHelper.lookup((CamelContext)this.getCamelContext(), (String)this.objectMapper, ObjectMapper.class);
            endpoint.setObjectMapper(om);
        } else if (this.useDefaultObjectMapper) {
            ObjectMapper om = (ObjectMapper)CamelContextHelper.findSingleByType((CamelContext)this.getCamelContext(), ObjectMapper.class);
            endpoint.setObjectMapper(om);
        }
        endpoint.setContentCache(this.contentCache);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public boolean isContentCache() {
        return this.contentCache;
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public boolean isUseDefaultObjectMapper() {
        return this.useDefaultObjectMapper;
    }

    public void setUseDefaultObjectMapper(boolean useDefaultObjectMapper) {
        this.useDefaultObjectMapper = useDefaultObjectMapper;
    }

    public String getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(String objectMapper) {
        this.objectMapper = objectMapper;
    }
}

