/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jslt;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.schibsted.spt.data.jslt.Expression;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.Parser;
import com.schibsted.spt.data.jslt.filters.DefaultJsonFilter;
import com.schibsted.spt.data.jslt.filters.JsonFilter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.ValidationException;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.jslt.JsltComponent;
import org.apache.camel.component.jslt.JsltConstants;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.1.0", scheme="jslt", title="JSLT", syntax="jslt:resourceUri", producerOnly=true, remote=false, category={Category.TRANSFORMATION}, headersClass=JsltConstants.class)
public class JsltEndpoint
extends ResourceEndpoint {
    private static final ObjectMapper OBJECT_MAPPER;
    private static final JsonFilter DEFAULT_JSON_FILTER;
    private Expression transform;
    @UriParam(defaultValue="false")
    private boolean allowTemplateFromHeader;
    @UriParam(defaultValue="false", label="common")
    private boolean prettyPrint;
    @UriParam(defaultValue="false")
    private boolean mapBigDecimalAsFloats;
    @UriParam
    private ObjectMapper objectMapper;

    public JsltEndpoint() {
    }

    public JsltEndpoint(String uri, JsltComponent component, String resourceUri) {
        super(uri, (Component)component, resourceUri);
    }

    public boolean isRemote() {
        return false;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "jslt:" + this.getResourceUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Expression getTransform(Message msg) throws Exception {
        Expression transform;
        InputStream stream;
        String transformSource;
        boolean useTemplateFromUri;
        String jsltStringFromHeader = this.allowTemplateFromHeader ? (String)msg.getHeader("CamelJsltString", String.class) : null;
        boolean bl = useTemplateFromUri = jsltStringFromHeader == null;
        if (useTemplateFromUri && this.transform != null) {
            return this.transform;
        }
        Collection functions = Objects.requireNonNullElse(((JsltComponent)this.getComponent()).getFunctions(), Collections.emptyList());
        JsonFilter objectFilter = Objects.requireNonNullElse(((JsltComponent)this.getComponent()).getObjectFilter(), DEFAULT_JSON_FILTER);
        if (useTemplateFromUri) {
            transformSource = this.getResourceUri();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Jslt content read from resource {} with resourceUri: {} for endpoint {}", new Object[]{transformSource, transformSource, this.getEndpointUri()});
            }
            if ((stream = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)transformSource)) == null) {
                throw new JsltException("Cannot load resource '" + transformSource + "': not found");
            }
        } else {
            stream = new ByteArrayInputStream(jsltStringFromHeader.getBytes(StandardCharsets.UTF_8));
            transformSource = "<inline>";
        }
        try {
            transform = new Parser((Reader)new InputStreamReader(stream)).withFunctions(functions).withObjectFilter(objectFilter).withSource(transformSource).compile();
        }
        finally {
            IOHelper.close((Closeable)stream);
        }
        if (useTemplateFromUri) {
            this.transform = transform;
        }
        return transform;
    }

    public JsltEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        this.log.debug("Getting endpoint with URI: {}", (Object)newUri);
        return (JsltEndpoint)this.getCamelContext().getEndpoint(newUri, JsltEndpoint.class);
    }

    protected void onExchange(Exchange exchange) throws Exception {
        JsonNode input;
        Object body;
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        String newResourceUri = null;
        if (this.allowTemplateFromHeader) {
            newResourceUri = (String)exchange.getIn().getHeader("CamelJsltResourceUri", String.class);
        }
        if (newResourceUri != null) {
            exchange.getIn().removeHeader("CamelJsltResourceUri");
            this.log.debug("{} set to {} creating new endpoint to handle exchange", (Object)"CamelJsltResourceUri", (Object)newResourceUri);
            JsltEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
            newEndpoint.onExchange(exchange);
            return;
        }
        ObjectMapper objectMapper = ObjectHelper.isEmpty((Object)this.getObjectMapper()) ? new ObjectMapper() : this.getObjectMapper();
        if (this.isMapBigDecimalAsFloats()) {
            objectMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        }
        if ((body = exchange.getIn().getBody()) instanceof WrappedFile) {
            body = ((WrappedFile)body).getFile();
        }
        if (body instanceof String) {
            input = objectMapper.readTree((String)body);
        } else if (body instanceof Reader) {
            input = objectMapper.readTree((Reader)body);
        } else if (body instanceof File) {
            input = objectMapper.readTree((File)body);
        } else if (body instanceof byte[]) {
            input = objectMapper.readTree((byte[])body);
        } else if (body instanceof InputStream) {
            input = objectMapper.readTree((InputStream)body);
        } else {
            throw new ValidationException(exchange, "Allowed body types are String, Reader, File, byte[] or InputStream.");
        }
        Map<String, JsonNode> variables = this.extractVariables(exchange);
        JsonNode output = this.getTransform(exchange.getMessage()).apply(variables, input);
        String result = this.isPrettyPrint() ? output.toPrettyString() : output.toString();
        ExchangeHelper.setInOutBodyPatternAware((Exchange)exchange, (Object)result);
    }

    private Map<String, JsonNode> extractVariables(Exchange exchange) {
        Map variableMap = ExchangeHelper.createVariableMap((Exchange)exchange, (boolean)this.isAllowContextMapAll());
        HashMap<String, JsonNode> serializedVariableMap = new HashMap<String, JsonNode>();
        if (variableMap.containsKey("headers")) {
            serializedVariableMap.put("headers", (JsonNode)this.serializeMapToJsonNode((Map)variableMap.get("headers")));
        }
        if (variableMap.containsKey("variables")) {
            serializedVariableMap.put("variables", (JsonNode)this.serializeMapToJsonNode((Map)variableMap.get("variables")));
        }
        if (variableMap.containsKey("exchange")) {
            Exchange ex = (Exchange)variableMap.get("exchange");
            ObjectNode exchangeNode = OBJECT_MAPPER.createObjectNode();
            if (ex.getProperties() != null) {
                exchangeNode.set("properties", (JsonNode)this.serializeMapToJsonNode(ex.getProperties()));
            }
            serializedVariableMap.put("exchange", (JsonNode)exchangeNode);
        }
        return serializedVariableMap;
    }

    private ObjectNode serializeMapToJsonNode(Map<String, Object> map) {
        ObjectNode mapNode = OBJECT_MAPPER.createObjectNode();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            try {
                mapNode.set(entry.getKey(), OBJECT_MAPPER.valueToTree(entry.getValue()));
            }
            catch (IllegalArgumentException e) {
                this.log.debug("Value could not be converted to JsonNode", (Throwable)e);
            }
        }
        return mapNode;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public boolean isMapBigDecimalAsFloats() {
        return this.mapBigDecimalAsFloats;
    }

    public void setMapBigDecimalAsFloats(boolean mapBigDecimalAsFloats) {
        this.mapBigDecimalAsFloats = mapBigDecimalAsFloats;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    static {
        DEFAULT_JSON_FILTER = new DefaultJsonFilter();
        OBJECT_MAPPER = new ObjectMapper();
        OBJECT_MAPPER.setSerializerFactory(OBJECT_MAPPER.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)new SafeTypesOnlySerializerModifier()));
    }

    private static class SafeTypesOnlySerializerModifier
    extends BeanSerializerModifier {
        private SafeTypesOnlySerializerModifier() {
        }

        public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
            Class beanClass = beanDesc.getBeanClass();
            if (Collection.class.isAssignableFrom(beanClass) || Map.class.isAssignableFrom(beanClass) || beanClass.isArray() || beanClass.isPrimitive() || SafeTypesOnlySerializerModifier.isRecord(beanClass) || Serializable.class.isAssignableFrom(beanClass)) {
                return serializer;
            }
            return ToStringSerializer.instance;
        }

        private static boolean isRecord(Class<?> clazz) {
            Class<?> parent = clazz.getSuperclass();
            return parent != null && parent.getName().equals("java.lang.Record");
        }
    }
}

