/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.jq;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.language.jq.JqFunctions;
import org.apache.camel.language.jq.JqLanguage;
import org.apache.camel.spi.ExpressionResultTypeAware;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.builder.ExpressionBuilder;

public class JqExpression
extends ExpressionAdapter
implements ExpressionResultTypeAware {
    private final String expression;
    private Scope scope;
    private String resultTypeName;
    private Class<?> resultType;
    private JsonQuery query;
    private TypeConverter typeConverter;
    private Expression source;

    public JqExpression(String expression) {
        this(null, expression);
    }

    public JqExpression(Scope scope, String expression) {
        this.scope = scope;
        this.expression = expression;
    }

    public void init(CamelContext camelContext) {
        if (this.query == null) {
            super.init(camelContext);
            if (this.scope == null) {
                JqLanguage lan = (JqLanguage)camelContext.resolveLanguage("jq");
                this.scope = Scope.newChildScope((Scope)lan.getRootScope());
            }
            this.typeConverter = camelContext.getTypeConverter();
            try {
                this.query = JsonQuery.compile((String)this.expression, (Version)Versions.JQ_1_7);
            }
            catch (JsonQueryException e) {
                throw new ExpressionIllegalSyntaxException(this.expression, (Throwable)e);
            }
            if (this.resultTypeName != null && (this.resultType == null || this.resultType == Object.class)) {
                this.resultType = camelContext.getClassResolver().resolveClass(this.resultTypeName);
            }
            if (this.resultType == null || this.resultType == Object.class) {
                this.resultType = JsonNode.class;
            }
        }
        if (this.source == null) {
            this.source = ExpressionBuilder.bodyExpression();
        }
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public String getExpressionText() {
        return this.expression;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public String getResultTypeName() {
        return this.resultTypeName;
    }

    public void setResultTypeName(String resultTypeName) {
        this.resultTypeName = resultTypeName;
    }

    public Expression getSource() {
        return this.source;
    }

    public void setSource(Expression source) {
        this.source = source;
    }

    public boolean matches(Exchange exchange) {
        Object value = this.evaluate(exchange, Object.class);
        if (value instanceof BooleanNode) {
            return ((BooleanNode)value).asBoolean();
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        return false;
    }

    public Object evaluate(Exchange exchange) {
        if (this.query == null) {
            return null;
        }
        try {
            JqFunctions.EXCHANGE_LOCAL.set(exchange);
            ArrayList outputs = new ArrayList(1);
            JsonNode payload = this.getPayload(exchange);
            this.query.apply(this.scope, payload, outputs::add);
            if (outputs.size() == 1) {
                JsonNode out = (JsonNode)outputs.get(0);
                if (out.isNull()) {
                    Object var5_8 = null;
                    return var5_8;
                }
                if (this.resultType == JsonNode.class) {
                    JsonNode jsonNode = out;
                    return jsonNode;
                }
                Object object = this.typeConverter.convertTo(this.resultType, exchange, outputs.get(0));
                return object;
            }
            if (outputs.size() > 1) {
                if (this.resultType == JsonNode.class) {
                    ArrayList arrayList = outputs;
                    return arrayList;
                }
                List list = outputs.stream().filter(o -> !o.isNull()).map(item -> this.typeConverter.convertTo(this.resultType, exchange, item)).collect(Collectors.toList());
                return list;
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        finally {
            JqFunctions.EXCHANGE_LOCAL.remove();
        }
        return null;
    }

    private JsonNode getPayload(Exchange exchange) throws Exception {
        JsonNode payload = (JsonNode)this.source.evaluate(exchange, JsonNode.class);
        MessageHelper.resetStreamCache((Message)exchange.getMessage());
        if (payload == null) {
            throw new InvalidPayloadException(exchange, JsonNode.class);
        }
        return payload;
    }
}

