/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.joor;

public class JoorCompilationException
extends RuntimeException {
    private final String className;
    private final String code;

    public JoorCompilationException(String className, String code, Throwable cause) {
        super("jOOR compilation error for class: " + className, cause);
        this.className = className;
        this.code = code;
    }

    public String getClassName() {
        return this.className;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + "\n\n" + this.codeWithLineNumbers() + "\n\n";
    }

    private String codeWithLineNumbers() {
        StringBuilder sb = new StringBuilder(256);
        String[] lines = this.code.split("\n");
        int counter = 0;
        for (String line : lines) {
            String s = String.format("%3d %s", ++counter, line);
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }
}

