/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class JMXEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":serverURL";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Map<String, String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "jmx".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "serverURL", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Map<String, String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(30);
        props.add("bridgeErrorHandler");
        props.add("differenceMode");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("executorService");
        props.add("format");
        props.add("granularityPeriod");
        props.add("handback");
        props.add("initThreshold");
        props.add("modulus");
        props.add("monitorType");
        props.add("notificationFilter");
        props.add("notifyDiffer");
        props.add("notifyHigh");
        props.add("notifyLow");
        props.add("notifyMatch");
        props.add("objectDomain");
        props.add("objectName");
        props.add("objectProperties");
        props.add("observedAttribute");
        props.add("offset");
        props.add("password");
        props.add("reconnectDelay");
        props.add("reconnectOnConnectionFailure");
        props.add("serverURL");
        props.add("stringToCompare");
        props.add("testConnectionOnStartup");
        props.add("thresholdHigh");
        props.add("thresholdLow");
        props.add("user");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("user");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashMap<String, String> prefixes = new HashMap<String, String>(1);
        prefixes.put("objectProperties", "key.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableMap(prefixes);
    }
}

