/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.Notification;

public class JMXConsumerNotificationFilter
extends AttributeChangeNotificationFilter {
    private final Lock lock = new ReentrantLock();
    private final String stringToCompare;
    private final boolean notifyMatch;

    public JMXConsumerNotificationFilter(String observedAttribute, String stringToCompare, boolean notifyMatch) {
        this.enableAttribute(observedAttribute);
        this.stringToCompare = stringToCompare;
        this.notifyMatch = notifyMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNotificationEnabled(Notification notification) {
        this.lock.lock();
        try {
            boolean enabled = super.isNotificationEnabled(notification);
            if (!enabled) {
                boolean bl = false;
                return bl;
            }
            boolean match = false;
            if (this.stringToCompare != null) {
                AttributeChangeNotification acn = (AttributeChangeNotification)notification;
                Object newValue = acn.getNewValue();
                if ("null".equals(this.stringToCompare) && newValue == null) {
                    match = true;
                } else if (newValue != null) {
                    match = this.stringToCompare.equals(newValue.toString());
                }
                boolean bl = this.notifyMatch == match;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

