/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.camel.impl.DefaultProducerTemplate;
import org.apache.camel.impl.ProducerTemplateProcessor;
import org.apache.camel.util.ObjectHelper;

public class CamelMessageListener
implements MessageListener,
Processor {
    private final CamelContext camelContext;
    private final Processor processor;
    private JmsBinding binding = new JmsBinding();
    private ExchangePattern pattern = ExchangePattern.InOnly;

    public CamelMessageListener(CamelContext camelContext, Processor processor) {
        this.camelContext = camelContext;
        this.processor = processor;
        ObjectHelper.notNull((Object)processor, (String)"processor");
    }

    public static CamelMessageListener newInstance(CamelContext camelContext, String endpointUri) {
        DefaultProducerTemplate producerTemplate = DefaultProducerTemplate.newInstance((CamelContext)camelContext, (String)endpointUri);
        return CamelMessageListener.newInstance(camelContext, (ProducerTemplate)producerTemplate);
    }

    public static CamelMessageListener newInstance(CamelContext camelContext, ProducerTemplate producerTemplate) {
        return new CamelMessageListener(camelContext, (Processor)new ProducerTemplateProcessor(producerTemplate));
    }

    public void onMessage(Message message) {
        try {
            Exchange exchange = this.createExchange(message);
            this.process(exchange);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public void process(Exchange exchange) throws Exception {
        ObjectHelper.notNull((Object)exchange, (String)"exchange");
        this.processor.process(exchange);
    }

    public JmsBinding getBinding() {
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    protected Exchange createExchange(Message message) {
        return new JmsExchange(this.camelContext, this.pattern, this.binding, message);
    }
}

