/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.camel.util.ObjectHelper;

public class MessageListenerProcessor
implements MessageListener {
    private final JmsEndpoint endpoint;
    private final Processor processor;

    public MessageListenerProcessor(JmsEndpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = processor;
    }

    public void onMessage(Message message) {
        try {
            JmsExchange exchange = this.endpoint.createExchange(message);
            this.processor.process((Exchange)exchange);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

