/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointMessageListener<E extends Exchange>
implements MessageListener {
    private static final transient Log LOG = LogFactory.getLog(EndpointMessageListener.class);
    private JmsEndpoint endpoint;
    private Processor processor;
    private JmsBinding binding;
    private boolean eagerLoadingOfProperties;

    public EndpointMessageListener(JmsEndpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = processor;
    }

    public void onMessage(Message message) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)((Object)((Object)this.endpoint) + " receiving JMS message: " + message));
            }
            JmsExchange exchange = this.createExchange(message);
            if (this.eagerLoadingOfProperties) {
                exchange.getIn().getHeaders();
            }
            this.processor.process((Exchange)exchange);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public JmsExchange createExchange(Message message) {
        return new JmsExchange(this.endpoint.getContext(), this.endpoint.getExchangePattern(), this.getBinding(), message);
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = new JmsBinding();
        }
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public boolean isEagerLoadingOfProperties() {
        return this.eagerLoadingOfProperties;
    }

    public void setEagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
        this.eagerLoadingOfProperties = eagerLoadingOfProperties;
    }
}

