/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.Message;
import org.apache.camel.Component;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsConsumer;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.camel.component.jms.JmsPollingConsumer;
import org.apache.camel.component.jms.JmsProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.AbstractMessageListenerContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsEndpoint
extends DefaultEndpoint<JmsExchange> {
    private JmsBinding binding;
    private String destination;
    private final boolean pubSubDomain;
    private String selector;
    private JmsConfiguration configuration;

    public JmsEndpoint(String uri, JmsComponent component, String destination, boolean pubSubDomain, JmsConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.destination = destination;
        this.pubSubDomain = pubSubDomain;
    }

    public JmsProducer createProducer() throws Exception {
        JmsOperations template = this.createJmsOperations();
        return this.createProducer(template);
    }

    public JmsProducer createProducer(JmsOperations template) throws Exception {
        if (template instanceof JmsTemplate) {
            JmsTemplate jmsTemplate = (JmsTemplate)template;
            jmsTemplate.setPubSubDomain(this.pubSubDomain);
            jmsTemplate.setDefaultDestinationName(this.destination);
        }
        return new JmsProducer(this, template);
    }

    public JmsConsumer createConsumer(Processor processor) throws Exception {
        AbstractMessageListenerContainer listenerContainer = this.configuration.createMessageListenerContainer();
        return this.createConsumer(processor, listenerContainer);
    }

    public JmsConsumer createConsumer(Processor processor, AbstractMessageListenerContainer listenerContainer) throws Exception {
        listenerContainer.setDestinationName(this.destination);
        listenerContainer.setPubSubDomain(this.pubSubDomain);
        if (this.selector != null) {
            listenerContainer.setMessageSelector(this.selector);
        }
        return new JmsConsumer(this, processor, listenerContainer);
    }

    public PollingConsumer<JmsExchange> createPollingConsumer() throws Exception {
        JmsOperations template = this.createJmsOperations();
        return new JmsPollingConsumer(this, template);
    }

    public JmsExchange createExchange() {
        return new JmsExchange(this.getContext(), this.getBinding());
    }

    public JmsExchange createExchange(Message message) {
        return new JmsExchange(this.getContext(), this.getBinding(), message);
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = new JmsBinding();
        }
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public String getDestination() {
        return this.destination;
    }

    public JmsConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public boolean isSingleton() {
        return false;
    }

    protected JmsOperations createJmsOperations() {
        return this.configuration.createJmsOperations(this.pubSubDomain, this.destination);
    }
}

