/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira;

import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClientFactory;
import java.net.URI;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jira.JiraComponent;
import org.apache.camel.component.jira.JiraConfiguration;
import org.apache.camel.component.jira.JiraConstants;
import org.apache.camel.component.jira.JiraType;
import org.apache.camel.component.jira.consumer.AbstractJiraConsumer;
import org.apache.camel.component.jira.consumer.NewCommentsConsumer;
import org.apache.camel.component.jira.consumer.NewIssuesConsumer;
import org.apache.camel.component.jira.consumer.WatchUpdatesConsumer;
import org.apache.camel.component.jira.oauth.JiraOAuthAuthenticationHandler;
import org.apache.camel.component.jira.oauth.OAuthAsynchronousJiraRestClientFactory;
import org.apache.camel.component.jira.producer.AddCommentProducer;
import org.apache.camel.component.jira.producer.AddIssueLinkProducer;
import org.apache.camel.component.jira.producer.AddIssueProducer;
import org.apache.camel.component.jira.producer.AddWorkLogProducer;
import org.apache.camel.component.jira.producer.AttachFileProducer;
import org.apache.camel.component.jira.producer.DeleteIssueProducer;
import org.apache.camel.component.jira.producer.FetchCommentsProducer;
import org.apache.camel.component.jira.producer.FetchIssueProducer;
import org.apache.camel.component.jira.producer.TransitionIssueProducer;
import org.apache.camel.component.jira.producer.UpdateIssueProducer;
import org.apache.camel.component.jira.producer.WatcherProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.0", scheme="jira", title="Jira", syntax="jira:type", category={Category.DOCUMENT}, headersClass=JiraConstants.class)
public class JiraEndpoint
extends DefaultEndpoint {
    private static final transient Logger LOG = LoggerFactory.getLogger(JiraEndpoint.class);
    private final Object lock = new Object();
    @UriPath
    @Metadata(required=true)
    private JiraType type;
    @UriParam(label="consumer")
    private String jql;
    @UriParam(label="consumer", defaultValue="Status,Priority")
    private String watchedFields = "Status,Priority";
    @UriParam(label="consumer", defaultValue="true")
    private boolean sendOnlyUpdatedField = true;
    @UriParam(label="consumer", defaultValue="50")
    private Integer maxResults = 50;
    @UriParam
    private JiraConfiguration configuration;
    private transient JiraRestClient client;

    public JiraEndpoint(String uri, JiraComponent component, JiraConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public JiraConfiguration getConfiguration() {
        return this.configuration;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.connect();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        if (this.client == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.client == null) {
                    Registry registry = this.getCamelContext().getRegistry();
                    Object factory = (JiraRestClientFactory)registry.lookupByNameAndType("JiraRestClientFactory", JiraRestClientFactory.class);
                    if (factory == null) {
                        factory = new OAuthAsynchronousJiraRestClientFactory();
                    }
                    URI jiraServerUri = URI.create(this.configuration.getJiraUrl());
                    if (this.configuration.getUsername() != null) {
                        LOG.debug("Connecting to JIRA with Basic authentication with username/password");
                        this.client = factory.createWithBasicHttpAuthentication(jiraServerUri, this.configuration.getUsername(), this.configuration.getPassword());
                    } else if (this.configuration.getAccessToken() != null && this.configuration.getVerificationCode() == null && this.configuration.getPrivateKey() == null && this.configuration.getConsumerKey() == null) {
                        this.client = factory.create(jiraServerUri, builder -> builder.setHeader("Authorization", "Bearer " + this.configuration.getAccessToken()));
                    } else {
                        LOG.debug("Connecting to JIRA with OAuth authentication");
                        JiraOAuthAuthenticationHandler oAuthHandler = new JiraOAuthAuthenticationHandler(this.configuration.getConsumerKey(), this.configuration.getVerificationCode(), this.configuration.getPrivateKey(), this.configuration.getAccessToken(), this.configuration.getJiraUrl());
                        this.client = factory.create(jiraServerUri, (AuthenticationHandler)oAuthHandler);
                    }
                }
            }
        }
    }

    public void disconnect() throws Exception {
        if (this.client != null) {
            LOG.debug("Disconnecting from JIRA");
            this.client.close();
            this.client = null;
        }
    }

    public Producer createProducer() {
        switch (this.type) {
            case ADDISSUE: {
                return new AddIssueProducer(this);
            }
            case ATTACH: {
                return new AttachFileProducer(this);
            }
            case ADDCOMMENT: {
                return new AddCommentProducer(this);
            }
            case WATCHERS: {
                return new WatcherProducer(this);
            }
            case DELETEISSUE: {
                return new DeleteIssueProducer(this);
            }
            case UPDATEISSUE: {
                return new UpdateIssueProducer(this);
            }
            case TRANSITIONISSUE: {
                return new TransitionIssueProducer(this);
            }
            case ADDISSUELINK: {
                return new AddIssueLinkProducer(this);
            }
            case ADDWORKLOG: {
                return new AddWorkLogProducer(this);
            }
            case FETCHISSUE: {
                return new FetchIssueProducer(this);
            }
            case FETCHCOMMENTS: {
                return new FetchCommentsProducer(this);
            }
        }
        throw new IllegalArgumentException("Producer does not support type: " + this.type);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        AbstractJiraConsumer consumer;
        if (this.type == JiraType.NEWCOMMENTS) {
            consumer = new NewCommentsConsumer(this, processor);
        } else if (this.type == JiraType.NEWISSUES) {
            consumer = new NewIssuesConsumer(this, processor);
        } else if (this.type == JiraType.WATCHUPDATES) {
            consumer = new WatchUpdatesConsumer(this, processor);
        } else {
            throw new IllegalArgumentException("Consumer does not support type: " + this.type);
        }
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public JiraType getType() {
        return this.type;
    }

    public void setType(JiraType type) {
        this.type = type;
    }

    public String getJql() {
        return this.jql;
    }

    public void setJql(String jql) {
        this.jql = jql;
    }

    public int getDelay() {
        return this.configuration.getDelay();
    }

    public JiraRestClient getClient() {
        this.connect();
        return this.client;
    }

    public void setClient(JiraRestClient client) {
        this.client = client;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public String getWatchedFields() {
        return this.watchedFields;
    }

    public void setWatchedFields(String watchChange) {
        this.watchedFields = watchChange;
    }

    public boolean isSendOnlyUpdatedField() {
        return this.sendOnlyUpdatedField;
    }

    public void setSendOnlyUpdatedField(boolean sendOnlyUpdatedField) {
        this.sendOnlyUpdatedField = sendOnlyUpdatedField;
    }
}

