/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty9;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.camel.component.jetty.CamelHttpClient;
import org.apache.camel.component.jetty.JettyHttpComponent;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.component.jetty9.CamelHttpClient9;
import org.apache.camel.component.jetty9.JettyHttpEndpoint9;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyHttpComponent9
extends JettyHttpComponent {
    private static final Logger LOG = LoggerFactory.getLogger(JettyHttpComponent9.class);

    protected CamelHttpClient createCamelHttpClient(HttpClientTransport transport, SslContextFactory sslContextFactory) {
        return new CamelHttpClient9(transport, sslContextFactory);
    }

    protected JettyHttpEndpoint createEndpoint(URI endpointUri, URI httpUri) throws URISyntaxException {
        return new JettyHttpEndpoint9(this, endpointUri.toString(), httpUri);
    }

    protected AbstractConnector createConnectorJettyInternal(Server server, JettyHttpEndpoint endpoint, SslContextFactory sslcf) {
        try {
            String host = endpoint.getHttpUri().getHost();
            int port = endpoint.getPort();
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSendServerVersion(endpoint.isSendServerVersion());
            httpConfig.setSendDateHeader(endpoint.isSendDateHeader());
            httpConfig.setSendDateHeader(endpoint.isSendDateHeader());
            if (this.requestBufferSize != null) {
                // empty if block
            }
            if (this.requestHeaderSize != null) {
                httpConfig.setRequestHeaderSize(this.requestHeaderSize.intValue());
            }
            if (this.responseBufferSize != null) {
                httpConfig.setOutputBufferSize(this.responseBufferSize.intValue());
            }
            if (this.responseHeaderSize != null) {
                httpConfig.setResponseHeaderSize(this.responseHeaderSize.intValue());
            }
            if (this.useXForwardedForHeader) {
                httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
            }
            HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfig);
            ArrayList<Object> connectionFactories = new ArrayList<Object>();
            ServerConnector result = new ServerConnector(server);
            if (sslcf != null) {
                httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                SslConnectionFactory scf = new SslConnectionFactory(sslcf, "HTTP/1.1");
                connectionFactories.add(scf);
                result.setDefaultProtocol(scf.getProtocol());
            }
            connectionFactories.add(httpFactory);
            result.setConnectionFactories(connectionFactories);
            result.setPort(port);
            if (host != null) {
                result.setHost(host);
            }
            if (sslcf != null) {
                if (this.getSslSocketConnectorProperties() != null && "https".equals(endpoint.getProtocol())) {
                    HashMap properties = new HashMap(this.getSslSocketConnectorProperties());
                    IntrospectionSupport.setProperties((Object)sslcf, properties);
                    if (properties.size() > 0) {
                        throw new IllegalArgumentException("There are " + properties.size() + " parameters that couldn't be set on the SocketConnector. Check the uri if the parameters are spelt correctly and that they are properties of the SelectChannelConnector. Unknown parameters=[" + properties + "]");
                    }
                }
                LOG.info("Connector on port: {} is using includeCipherSuites: {} excludeCipherSuites: {} includeProtocols: {} excludeProtocols: {}", new Object[]{port, sslcf.getIncludeCipherSuites(), sslcf.getExcludeCipherSuites(), sslcf.getIncludeProtocols(), sslcf.getExcludeProtocols()});
            }
            return result;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

