/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty12;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Category;
import org.apache.camel.component.jetty.JettyHttpComponent;
import org.apache.camel.component.jetty.JettyHttpConstants;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.component.jetty12.AttachmentHttpBinding;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;

@UriEndpoint(firstVersion="1.2.0", scheme="jetty", extendsScheme="http", title="Jetty", syntax="jetty:httpUri", category={Category.HTTP}, consumerOnly=true, lenientProperties=true, headersClass=JettyHttpConstants.class)
@Metadata(excludeProperties="authMethod,authMethodPriority,authUsername,authPassword,authDomain,authHost,authBearerToken,proxyAuthScheme,proxyAuthMethod,proxyAuthUsername,proxyAuthPassword,proxyAuthHost,proxyAuthPort,proxyAuthDomain", annotations={"protocol=http"})
public class JettyHttpEndpoint12
extends JettyHttpEndpoint
implements AsyncEndpoint {
    private HttpBinding binding;

    public JettyHttpEndpoint12(JettyHttpComponent component, String uri, URI httpURL) throws URISyntaxException {
        super(component, uri, httpURL);
    }

    public HttpBinding getHttpBinding() {
        if (this.binding == null) {
            this.binding = new AttachmentHttpBinding();
            this.binding.setTransferException(this.isTransferException());
            this.binding.setMuteException(this.isMuteException());
            this.binding.setLogException(this.isLogException());
            if (this.getComponent() != null) {
                this.binding.setAllowJavaSerializedObject(this.getComponent().isAllowJavaSerializedObject());
            }
            this.binding.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
            this.binding.setEagerCheckContentAvailable(this.isEagerCheckContentAvailable());
            this.binding.setMapHttpMessageBody(this.isMapHttpMessageBody());
            this.binding.setMapHttpMessageHeaders(this.isMapHttpMessageHeaders());
            this.binding.setMapHttpMessageFormUrlEncodedBody(this.isMapHttpMessageFormUrlEncodedBody());
        }
        return this.binding;
    }

    public void setHttpBinding(HttpBinding binding) {
        super.setHttpBinding(binding);
        this.binding = binding;
    }
}

