/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty11;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.attachment.Attachment;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.attachment.DefaultAttachment;
import org.apache.camel.http.common.DefaultHttpBinding;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpMessage;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AttachmentHttpBinding
extends DefaultHttpBinding {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentHttpBinding.class);

    AttachmentHttpBinding() {
    }

    protected void populateAttachments(HttpServletRequest request, HttpMessage message) {
        Boolean object = (Boolean)request.getAttribute("populate.multipart");
        if (object != null && object.booleanValue()) {
            try {
                Collection parts = request.getParts();
                for (Part part : parts) {
                    PartDataSource ds = new PartDataSource(part);
                    DefaultAttachment attachment = new DefaultAttachment((DataSource)ds);
                    for (String headerName : part.getHeaderNames()) {
                        for (String headerValue : part.getHeaders(headerName)) {
                            attachment.addHeader(headerName, headerValue);
                        }
                    }
                    AttachmentMessage am = (AttachmentMessage)message.getExchange().getMessage(AttachmentMessage.class);
                    am.addAttachmentObject(part.getName(), (Attachment)attachment);
                    String name = part.getSubmittedFileName();
                    DataHandler value = am.getAttachment(name);
                    Map headers = message.getHeaders();
                    if (this.getHeaderFilterStrategy() == null || this.getHeaderFilterStrategy().applyFilterToExternalHeaders(name, (Object)value, message.getExchange()) || name == null) continue;
                    HttpHelper.appendHeader((Map)headers, (String)name, (Object)value);
                }
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Cannot populate attachments", (Throwable)e);
            }
        }
    }

    protected void populateRequestParameters(HttpServletRequest request, HttpMessage message) {
        Map headers = message.getHeaders();
        if (request instanceof Request) {
            Request jettyRequest = (Request)request;
            HttpFields originalFields = jettyRequest.getHttpFields();
            HttpFields.Mutable newFields = HttpFields.build((HttpFields)originalFields).remove("Content-Encoding");
            jettyRequest.setHttpFields((HttpFields)newFields);
        }
        AttachmentMessage am = (AttachmentMessage)message.getExchange().getMessage(AttachmentMessage.class);
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (am != null && am.getAttachment(name) != null) {
                DataHandler dh;
                Object value = dh = am.getAttachment(name);
                if (dh.getContentType() == null || dh.getContentType().startsWith("text/plain")) {
                    value = request.getParameter(name);
                }
                if (this.getHeaderFilterStrategy() == null || this.getHeaderFilterStrategy().applyFilterToExternalHeaders(name, value, message.getExchange())) continue;
                HttpHelper.appendHeader((Map)headers, (String)name, (Object)value);
                continue;
            }
            String[] values = request.getParameterValues(name);
            LOG.trace("HTTP parameter {} = {}", (Object)name, (Object)values);
            if (values == null) continue;
            for (String value : values) {
                if (this.getHeaderFilterStrategy() == null || this.getHeaderFilterStrategy().applyFilterToExternalHeaders(name, (Object)value, message.getExchange())) continue;
                HttpHelper.appendHeader((Map)headers, (String)name, (Object)value);
            }
        }
    }

    static final class PartDataSource
    implements DataSource {
        private final Part part;

        PartDataSource(Part part) {
            this.part = part;
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public String getName() {
            return this.part.getName();
        }

        public InputStream getInputStream() throws IOException {
            return this.part.getInputStream();
        }

        public String getContentType() {
            return this.part.getContentType();
        }
    }
}

