/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import jakarta.servlet.Filter;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.Service;
import org.apache.camel.component.jetty.CamelContinuationServlet;
import org.apache.camel.component.jetty.CamelFilterWrapper;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.component.jetty.JettyRestHttpBinding;
import org.apache.camel.component.jetty.MultiPartFilter;
import org.apache.camel.http.common.CamelServlet;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpCommonComponent;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.http.common.HttpConfiguration;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.HttpRestServletResolveConsumerStrategy;
import org.apache.camel.http.common.ServletResolveConsumerStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.RestComponentHelper;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.ee10.servlets.CrossOriginFilter;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JettyHttpComponent
extends HttpCommonComponent
implements RestConsumerFactory,
RestApiConsumerFactory,
SSLContextParametersAware {
    public static final String TMP_DIR = "CamelJettyTempDir";
    protected static final HashMap<String, ConnectorRef> CONNECTORS = new HashMap();
    private static final Logger LOG = LoggerFactory.getLogger(JettyHttpComponent.class);
    private static final String JETTY_SSL_KEYSTORE = "org.eclipse.jetty.ssl.keystore";
    private static final String JETTY_SSL_KEYPASSWORD = "org.eclipse.jetty.ssl.keypassword";
    private static final String JETTY_SSL_PASSWORD = "org.eclipse.jetty.ssl.password";
    protected String sslKeyPassword;
    protected String sslPassword;
    protected String sslKeystore;
    protected Map<Integer, Connector> sslSocketConnectors;
    protected Map<Integer, Connector> socketConnectors;
    protected Map<String, Object> sslSocketConnectorProperties;
    protected Map<String, Object> socketConnectorProperties;
    protected Integer minThreads;
    protected Integer maxThreads;
    protected ThreadPool threadPool;
    protected MBeanContainer mbContainer;
    protected boolean enableJmx;
    protected Long continuationTimeout;
    protected boolean useContinuation = true;
    protected SSLContextParameters sslContextParameters;
    protected boolean useGlobalSslContextParameters;
    protected Integer requestBufferSize;
    protected Integer requestHeaderSize;
    protected Integer responseBufferSize;
    protected Integer responseHeaderSize;
    protected String proxyHost;
    protected ErrorHandler errorHandler;
    protected boolean useXForwardedForHeader;
    private Integer proxyPort;
    private boolean sendServerVersion = true;
    private QueuedThreadPool defaultQueuedThreadPool;
    private String filesLocation;
    private Long maxFileSize = -1L;
    private Long maxRequestSize = -1L;
    private Integer fileSizeThreshold = 0;

    protected JettyHttpComponent() {
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        List handlerList = this.resolveAndRemoveReferenceListParameter(parameters, "handlers", Handler.class);
        HttpBinding binding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBindingRef", HttpBinding.class);
        Boolean enableJmx = (Boolean)this.getAndRemoveParameter(parameters, "enableJmx", Boolean.class);
        Boolean enableMultipartFilter = (Boolean)this.getAndRemoveParameter(parameters, "enableMultipartFilter", Boolean.class, true);
        Filter multipartFilter = (Filter)this.resolveAndRemoveReferenceParameter(parameters, "multipartFilterRef", Filter.class);
        ArrayList<CrossOriginFilter> filters = this.resolveAndRemoveReferenceListParameter(parameters, "filters", Filter.class);
        Boolean enableCors = (Boolean)this.getAndRemoveParameter(parameters, "enableCORS", Boolean.class, false);
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        SSLContextParameters sslContextParameters = (SSLContextParameters)this.resolveAndRemoveReferenceParameter(parameters, "sslContextParameters", SSLContextParameters.class);
        SSLContextParameters ssl = sslContextParameters != null ? sslContextParameters : this.sslContextParameters;
        ssl = ssl != null ? ssl : this.retrieveGlobalSslContextParameters();
        String proxyHost = (String)this.getAndRemoveParameter(parameters, "proxyHost", String.class, this.getProxyHost());
        Integer proxyPort = (Integer)this.getAndRemoveParameter(parameters, "proxyPort", Integer.class, this.getProxyPort());
        Boolean async = (Boolean)this.getAndRemoveParameter(parameters, "async", Boolean.class);
        boolean muteException = (Boolean)this.getAndRemoveParameter(parameters, "muteException", Boolean.TYPE, this.isMuteException());
        String filesLocation = (String)this.getAndRemoveParameter(parameters, "filesLocation", String.class, this.getFilesLocation());
        Integer fileSizeThreshold = (Integer)this.getAndRemoveParameter(parameters, "fileSizeThreshold", Integer.class, this.getFileSizeThreshold());
        Long maxFileSize = (Long)this.getAndRemoveParameter(parameters, "maxFileSize", Long.class, this.getMaxFileSize());
        Long maxRequestSize = (Long)this.getAndRemoveParameter(parameters, "maxRequestSize", Long.class, this.getMaxRequestSize());
        Map filterInitParameters = PropertiesHelper.extractProperties(parameters, (String)"filterInit.");
        URI addressUri = new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)remaining));
        URI endpointUri = URISupport.createRemainingURI((URI)addressUri, parameters);
        String httpMethodRestrict = (String)this.getAndRemoveParameter(parameters, "httpMethodRestrict", String.class);
        URI httpUri = URISupport.createRemainingURI((URI)addressUri, parameters);
        String scheme = StringHelper.before((String)uri, (String)":");
        endpointUri = new URI(scheme + ":" + endpointUri);
        JettyHttpEndpoint endpoint = this.createEndpoint(endpointUri, httpUri);
        if (async != null) {
            endpoint.setAsync(async);
        }
        endpoint.setMuteException(muteException);
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        }
        if (proxyHost != null) {
            endpoint.setProxyHost(proxyHost);
            endpoint.setProxyPort(proxyPort);
        }
        if (!filterInitParameters.isEmpty()) {
            endpoint.setFilterInitParameters(filterInitParameters);
        }
        if (!handlerList.isEmpty()) {
            endpoint.setHandlers(handlerList);
        }
        if (binding == null) {
            binding = this.getHttpBinding();
        }
        if (binding != null) {
            endpoint.setHttpBinding(binding);
        }
        if (enableJmx != null) {
            endpoint.setEnableJmx(enableJmx);
        } else {
            endpoint.setEnableJmx(this.isEnableJmx());
        }
        endpoint.setEnableMultipartFilter(enableMultipartFilter);
        if (multipartFilter != null) {
            endpoint.setMultipartFilter(multipartFilter);
            endpoint.setEnableMultipartFilter(true);
        }
        if (enableCors.booleanValue()) {
            endpoint.setEnableCORS(enableCors);
            if (filters == null) {
                filters = new ArrayList<CrossOriginFilter>(1);
            }
            filters.add(new CrossOriginFilter());
        }
        if (filters != null) {
            endpoint.setFilters((List<Filter>)filters);
        }
        if (httpMethodRestrict != null) {
            endpoint.setHttpMethodRestrict(httpMethodRestrict);
        }
        if (ssl != null) {
            endpoint.setSslContextParameters(ssl);
        }
        endpoint.setSendServerVersion(this.isSendServerVersion());
        endpoint.setFilesLocation(filesLocation);
        endpoint.setFileSizeThreshold(fileSizeThreshold);
        endpoint.setMaxFileSize(maxFileSize);
        endpoint.setMaxRequestSize(maxRequestSize);
        this.setProperties((Endpoint)endpoint, parameters);
        httpUri = URISupport.createRemainingURI((URI)addressUri, parameters);
        endpoint.setHttpUri(httpUri);
        return endpoint;
    }

    protected abstract JettyHttpEndpoint createEndpoint(URI var1, URI var2) throws URISyntaxException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canConnect(HttpConsumer consumer) throws Exception {
        JettyHttpEndpoint endpoint = (JettyHttpEndpoint)consumer.getEndpoint();
        String connectorKey = this.getConnectorKey(endpoint);
        HashMap<String, ConnectorRef> hashMap = CONNECTORS;
        synchronized (hashMap) {
            ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
            if (connectorRef != null) {
                for (Map.Entry entry : connectorRef.servlet.getConsumers().entrySet()) {
                    boolean sameContext;
                    String path = ((HttpConsumer)entry.getValue()).getPath();
                    CamelContext camelContext = ((HttpConsumer)entry.getValue()).getEndpoint().getCamelContext();
                    if (!consumer.getPath().equals(path) || (sameContext = consumer.getEndpoint().getCamelContext() == camelContext)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(HttpConsumer consumer) throws Exception {
        JettyHttpEndpoint endpoint = (JettyHttpEndpoint)consumer.getEndpoint();
        String connectorKey = this.getConnectorKey(endpoint);
        HashMap<String, ConnectorRef> hashMap = CONNECTORS;
        synchronized (hashMap) {
            ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
            if (connectorRef == null) {
                Server server = this.createServer();
                Connector connector = this.getConnector(server, endpoint);
                if ("localhost".equalsIgnoreCase(endpoint.getHttpUri().getHost())) {
                    LOG.warn("You use localhost interface! It means that no external connections will be available. Don't you want to use 0.0.0.0 instead (all network interfaces)? {}", (Object)endpoint);
                }
                if (endpoint.isEnableJmx()) {
                    this.enableJmx(server);
                }
                server.addConnector(connector);
                connectorRef = new ConnectorRef(server, connector, this.createServletForConnector(server, connector, endpoint.getHandlers(), endpoint));
                if (endpoint.isSessionSupport()) {
                    this.enableSessionSupport(connectorRef.server, connectorKey);
                }
                connectorRef.server.start();
                LOG.debug("Adding connector key: {} -> {}", (Object)connectorKey, (Object)connectorRef);
                CONNECTORS.put(connectorKey, connectorRef);
            } else {
                LOG.debug("Using existing connector key: {} -> {}", (Object)connectorKey, (Object)connectorRef);
                if (endpoint.getHandlers() != null && !endpoint.getHandlers().isEmpty()) {
                    ArrayList<Handler> newHandlers;
                    boolean changed;
                    List existingHandlers = new ArrayList();
                    if (connectorRef.server.getHandlers() != null && !connectorRef.server.getHandlers().isEmpty()) {
                        existingHandlers = connectorRef.server.getHandlers();
                    }
                    boolean bl = changed = !existingHandlers.containsAll(newHandlers = new ArrayList<Handler>(endpoint.getHandlers())) && !newHandlers.containsAll(existingHandlers);
                    if (changed) {
                        LOG.debug("Restarting Jetty server due to adding new Jetty Handlers: {}", newHandlers);
                        connectorRef.server.stop();
                        this.addJettyHandlers(connectorRef.server, endpoint.getHandlers());
                        connectorRef.server.start();
                    }
                }
                if (endpoint.isSessionSupport()) {
                    this.enableSessionSupport(connectorRef.server, connectorKey);
                }
                connectorRef.increment();
            }
            if (endpoint.isEnableMultipartFilter()) {
                this.enableMultipartFilter(endpoint, connectorRef.server);
            }
            if (endpoint.getFilters() != null && !endpoint.getFilters().isEmpty()) {
                this.setFilters(endpoint, connectorRef.server);
            }
            connectorRef.servlet.connect(consumer);
        }
    }

    private void enableJmx(Server server) {
        MBeanContainer containerToRegister = this.getMbContainer();
        if (containerToRegister != null) {
            LOG.info("Jetty JMX Extensions is enabled");
            this.addServerMBean(server);
        }
    }

    private void enableSessionSupport(Server server, String connectorKey) throws Exception {
        ServletContextHandler context = (ServletContextHandler)server.getDescendant(ServletContextHandler.class);
        if (context.getSessionHandler() == null) {
            SessionHandler sessionHandler = new SessionHandler();
            if (context.isStarted()) {
                throw new IllegalStateException("Server has already been started. Cannot enabled sessionSupport on " + connectorKey);
            }
            context.setSessionHandler(sessionHandler);
        }
    }

    private void setFilters(JettyHttpEndpoint endpoint, Server server) {
        ServletContextHandler context = (ServletContextHandler)server.getDescendant(ServletContextHandler.class);
        List<Filter> filters = endpoint.getFilters();
        for (Filter filter : filters) {
            FilterHolder filterHolder = new FilterHolder();
            if (endpoint.getFilterInitParameters() != null) {
                filterHolder.setInitParameters(endpoint.getFilterInitParameters());
            }
            this.addFilter(endpoint, filter, filterHolder, context);
        }
    }

    private void addFilter(JettyHttpEndpoint endpoint, Filter filter, FilterHolder filterHolder, ServletContextHandler context) {
        this.addFilter((HttpCommonEndpoint)endpoint, filterHolder, filter, context);
    }

    private void addFilter(ServletContextHandler context, FilterHolder filterHolder, String pathSpec) {
        context.getServletHandler().addFilterWithMapping(filterHolder, pathSpec, 0);
    }

    private void enableMultipartFilter(HttpCommonEndpoint endpoint, Server server) throws Exception {
        Filter filter;
        ServletContextHandler context = (ServletContextHandler)server.getDescendant(ServletContextHandler.class);
        CamelContext camelContext = this.getCamelContext();
        FilterHolder filterHolder = new FilterHolder();
        filterHolder.setInitParameter("deleteFiles", "true");
        if (ObjectHelper.isNotEmpty((String)camelContext.getGlobalOption(TMP_DIR))) {
            File file = new File(camelContext.getGlobalOption(TMP_DIR));
            if (!file.isDirectory()) {
                throw new RuntimeCamelException("The temp file directory of camel-jetty is not exists, please recheck it with directory name :" + (String)camelContext.getGlobalOptions().get(TMP_DIR));
            }
            context.setAttribute("jakarta.servlet.context.tempdir", (Object)file);
        }
        if ((filter = ((JettyHttpEndpoint)endpoint).getMultipartFilter()) == null) {
            filter = new MultiPartFilter();
        }
        String pathSpec = this.addFilter(endpoint, filterHolder, filter, context);
        LOG.debug("using multipart filter implementation {} for path {}", (Object)filter.getClass().getName(), (Object)pathSpec);
    }

    private String addFilter(HttpCommonEndpoint endpoint, FilterHolder filterHolder, Filter filter, ServletContextHandler context) {
        filterHolder.setFilter((Filter)new CamelFilterWrapper(filter));
        Object pathSpec = endpoint.getPath();
        if (pathSpec == null || ((String)pathSpec).isEmpty()) {
            pathSpec = "/";
        }
        if (endpoint.isMatchOnUriPrefix()) {
            pathSpec = ((String)pathSpec).endsWith("/") ? (String)pathSpec + "*" : (String)pathSpec + "/*";
        }
        this.addFilter(context, filterHolder, (String)pathSpec);
        return pathSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(HttpConsumer consumer) throws Exception {
        HttpCommonEndpoint endpoint = consumer.getEndpoint();
        String connectorKey = this.getConnectorKey(endpoint);
        HashMap<String, ConnectorRef> hashMap = CONNECTORS;
        synchronized (hashMap) {
            ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
            if (connectorRef != null) {
                connectorRef.servlet.disconnect(consumer);
                if (connectorRef.decrement() == 0) {
                    connectorRef.server.removeConnector(connectorRef.connector);
                    connectorRef.connector.stop();
                    connectorRef.server.stop();
                    CONNECTORS.remove(connectorKey);
                    if (this.mbContainer != null) {
                        this.removeServerMBean(connectorRef.server);
                    }
                    if (this.defaultQueuedThreadPool != null) {
                        try {
                            this.defaultQueuedThreadPool.stop();
                        }
                        catch (Exception t) {
                            this.defaultQueuedThreadPool.destroy();
                        }
                        finally {
                            this.defaultQueuedThreadPool = null;
                        }
                    }
                }
            }
        }
    }

    private String getConnectorKey(HttpCommonEndpoint endpoint) {
        return endpoint.getProtocol() + ":" + endpoint.getHttpUri().getHost() + ":" + endpoint.getPort();
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    @Metadata(description="The key password, which is used to access the certificate's key entry in the keystore (this is the same password that is supplied to the keystore command's -keypass option).", label="security", secret=true)
    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public String getSslPassword() {
        return this.sslPassword;
    }

    @Metadata(description="The ssl password, which is required to access the keystore file (this is the same password that is supplied to the keystore command's -storepass option).", label="security", secret=true)
    public void setSslPassword(String sslPassword) {
        this.sslPassword = sslPassword;
    }

    @Metadata(description="Specifies the location of the Java keystore file, which contains the Jetty server's own X.509 certificate in a key entry.", label="security", secret=true)
    public void setKeystore(String sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public String getKeystore() {
        return this.sslKeystore;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Metadata(description="This option is used to set the ErrorHandler that Jetty server uses.", label="advanced")
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected Connector getConnector(Server server, JettyHttpEndpoint endpoint) {
        Connector connector = "https".equals(endpoint.getProtocol()) ? this.getSslSocketConnector(server, endpoint) : this.getSocketConnector(server, endpoint);
        return connector;
    }

    protected Connector getSocketConnector(Server server, JettyHttpEndpoint endpoint) {
        Connector answer = null;
        if (this.socketConnectors != null) {
            answer = this.socketConnectors.get(endpoint.getPort());
        }
        if (answer == null) {
            answer = this.createConnector(server, endpoint);
        }
        return answer;
    }

    protected Connector getSslSocketConnector(Server server, JettyHttpEndpoint endpoint) {
        Connector answer = null;
        if (this.sslSocketConnectors != null) {
            answer = this.sslSocketConnectors.get(endpoint.getPort());
        }
        if (answer == null) {
            answer = this.createConnector(server, endpoint);
        }
        return answer;
    }

    protected Connector createConnector(Server server, JettyHttpEndpoint endpoint) {
        SslContextFactory.Server sslcf = null;
        SSLContextParameters endpointSslContextParameters = endpoint.getSslContextParameters();
        if (endpointSslContextParameters != null) {
            try {
                sslcf = (SslContextFactory.Server)this.createSslContextFactory(endpointSslContextParameters, false);
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        } else if ("https".equals(endpoint.getProtocol())) {
            sslcf = new SslContextFactory.Server();
            sslcf.setEndpointIdentificationAlgorithm(null);
            String keystoreProperty = System.getProperty(JETTY_SSL_KEYSTORE);
            if (keystoreProperty != null) {
                sslcf.setKeyStorePath(keystoreProperty);
            } else if (this.sslKeystore != null) {
                sslcf.setKeyStorePath(this.sslKeystore);
            }
            String keystorePassword = System.getProperty(JETTY_SSL_KEYPASSWORD);
            if (keystorePassword != null) {
                sslcf.setKeyManagerPassword(keystorePassword);
            } else if (this.sslKeyPassword != null) {
                sslcf.setKeyManagerPassword(this.sslKeyPassword);
            }
            String password = System.getProperty(JETTY_SSL_PASSWORD);
            if (password != null) {
                sslcf.setKeyStorePassword(password);
            } else if (this.sslPassword != null) {
                sslcf.setKeyStorePassword(this.sslPassword);
            }
        }
        return this.createConnectorJettyInternal(server, endpoint, sslcf);
    }

    protected abstract AbstractConnector createConnectorJettyInternal(Server var1, JettyHttpEndpoint var2, SslContextFactory.Server var3);

    private SslContextFactory createSslContextFactory(SSLContextParameters ssl, boolean client) throws GeneralSecurityException, IOException {
        String[] arr;
        String[] arr2;
        Object answer = !client ? new SslContextFactory.Server() : new SslContextFactory.Client();
        if (ssl != null) {
            answer.setSslContext(ssl.createSSLContext(this.getCamelContext()));
        }
        if (ssl != null && ssl.getCipherSuitesFilter() != null) {
            List includeCiphers = ssl.getCipherSuitesFilter().getInclude();
            if (includeCiphers != null && !includeCiphers.isEmpty()) {
                arr2 = includeCiphers.toArray(new String[0]);
                answer.setIncludeCipherSuites(arr2);
            } else {
                answer.setIncludeCipherSuites(new String[]{".*"});
            }
            List excludeCiphers = ssl.getCipherSuitesFilter().getExclude();
            if (excludeCiphers != null && !excludeCiphers.isEmpty()) {
                arr = excludeCiphers.toArray(new String[0]);
                answer.setExcludeCipherSuites(arr);
            }
        }
        if (ssl != null && ssl.getSecureSocketProtocolsFilter() != null) {
            List includeProtocols = ssl.getSecureSocketProtocolsFilter().getInclude();
            if (includeProtocols != null && !includeProtocols.isEmpty()) {
                arr2 = includeProtocols.toArray(new String[0]);
                answer.setIncludeProtocols(arr2);
            } else {
                answer.setIncludeProtocols(new String[]{".*"});
            }
            List excludeProtocols = ssl.getSecureSocketProtocolsFilter().getExclude();
            if (excludeProtocols != null && !excludeProtocols.isEmpty()) {
                arr = excludeProtocols.toArray(new String[0]);
                answer.setExcludeProtocols(arr);
            }
        }
        return answer;
    }

    protected boolean checkSSLContextFactoryConfig(Object instance) {
        try {
            Method method = instance.getClass().getMethod("checkConfig", new Class[0]);
            return (Boolean)method.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            return false;
        }
    }

    public Map<Integer, Connector> getSslSocketConnectors() {
        return this.sslSocketConnectors;
    }

    @Metadata(description="A map which contains per port number specific SSL connectors.", label="security")
    public void setSslSocketConnectors(Map<Integer, Connector> connectors) {
        this.sslSocketConnectors = connectors;
    }

    @Metadata(description="A map which contains per port number specific HTTP connectors. Uses the same principle as sslSocketConnectors.", label="security")
    public void setSocketConnectors(Map<Integer, Connector> socketConnectors) {
        this.socketConnectors = socketConnectors;
    }

    public Map<Integer, Connector> getSocketConnectors() {
        return this.socketConnectors;
    }

    public Integer getMinThreads() {
        return this.minThreads;
    }

    @Metadata(description="To set a value for minimum number of threads in server thread pool. Notice that both a min and max size must be configured.", label="consumer")
    public void setMinThreads(Integer minThreads) {
        this.minThreads = minThreads;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    @Metadata(description="To set a value for maximum number of threads in server thread pool. Notice that both a min and max size must be configured.", label="consumer")
    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    @Metadata(description="To use a custom thread pool for the server. This option should only be used in special circumstances.", label="consumer,advanced")
    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    @Metadata(description="If this option is true, Jetty JMX support will be enabled for this endpoint.")
    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    @Metadata(description="Not to be used - use JettyHttpBinding instead.", label="advanced")
    public void setHttpBinding(HttpBinding httpBinding) {
        throw new IllegalArgumentException("Not to be used - use JettyHttpBinding instead.");
    }

    @Metadata(description="Jetty component does not use HttpConfiguration.", label="advanced")
    public void setHttpConfiguration(HttpConfiguration httpConfiguration) {
        throw new IllegalArgumentException("Jetty component does not use HttpConfiguration.");
    }

    public synchronized MBeanContainer getMbContainer() {
        if (this.mbContainer == null) {
            MBeanServer mbs = null;
            ManagementStrategy mStrategy = this.getCamelContext().getManagementStrategy();
            ManagementAgent mAgent = mStrategy.getManagementAgent();
            if (mAgent != null) {
                mbs = mAgent.getMBeanServer();
            }
            if (mbs != null) {
                this.mbContainer = new MBeanContainer(mbs);
            } else {
                LOG.warn("JMX disabled in CamelContext. Jetty JMX extensions will remain disabled.");
            }
        }
        return this.mbContainer;
    }

    @Metadata(description="To use a existing configured org.eclipse.jetty.jmx.MBeanContainer if JMX is enabled that Jetty uses for registering mbeans.", label="advanced")
    public void setMbContainer(MBeanContainer mbContainer) {
        this.mbContainer = mbContainer;
    }

    public Map<String, Object> getSslSocketConnectorProperties() {
        return this.sslSocketConnectorProperties;
    }

    @Metadata(description="A map which contains general SSL connector properties.", label="security")
    public void setSslSocketConnectorProperties(Map<String, Object> sslSocketConnectorProperties) {
        this.sslSocketConnectorProperties = sslSocketConnectorProperties;
    }

    public Map<String, Object> getSocketConnectorProperties() {
        return this.socketConnectorProperties;
    }

    @Metadata(description="A map which contains general HTTP connector properties. Uses the same principle as sslSocketConnectorProperties.", label="security")
    public void setSocketConnectorProperties(Map<String, Object> socketConnectorProperties) {
        this.socketConnectorProperties = socketConnectorProperties;
    }

    public void addSocketConnectorProperty(String key, Object value) {
        if (this.socketConnectorProperties == null) {
            this.socketConnectorProperties = new HashMap<String, Object>();
        }
        this.socketConnectorProperties.put(key, value);
    }

    public void addSslSocketConnectorProperty(String key, Object value) {
        if (this.sslSocketConnectorProperties == null) {
            this.sslSocketConnectorProperties = new HashMap<String, Object>();
        }
        this.sslSocketConnectorProperties.put(key, value);
    }

    public Long getContinuationTimeout() {
        return this.continuationTimeout;
    }

    @Metadata(description="Allows to set a timeout in millis when using Jetty as consumer (server). By default Jetty uses 30000. You can use a value of <= 0 to never expire. If a timeout occurs then the request will be expired and Jetty will return back a http error 503 to the client. This option is only in use when using Jetty with the Asynchronous Routing Engine.", defaultValue="30000", label="consumer")
    public void setContinuationTimeout(Long continuationTimeout) {
        this.continuationTimeout = continuationTimeout;
    }

    public boolean isUseContinuation() {
        return this.useContinuation;
    }

    @Metadata(description="Whether or not to use Jetty continuations for the Jetty Server.", defaultValue="true", label="consumer")
    public void setUseContinuation(boolean useContinuation) {
        this.useContinuation = useContinuation;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    @Metadata(description="To configure security using SSLContextParameters", label="security")
    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    @Metadata(description="Enable usage of global SSL context parameters", label="security", defaultValue="false")
    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public Integer getResponseBufferSize() {
        return this.responseBufferSize;
    }

    @Metadata(description="Allows to configure a custom value of the response buffer size on the Jetty connectors.")
    public void setResponseBufferSize(Integer responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
    }

    public Integer getRequestBufferSize() {
        return this.requestBufferSize;
    }

    @Metadata(description="Allows to configure a custom value of the request buffer size on the Jetty connectors.")
    public void setRequestBufferSize(Integer requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public Integer getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    @Metadata(description="Allows to configure a custom value of the request header size on the Jetty connectors.")
    public void setRequestHeaderSize(Integer requestHeaderSize) {
        this.requestHeaderSize = requestHeaderSize;
    }

    public Integer getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    @Metadata(description="Allows to configure a custom value of the response header size on the Jetty connectors.")
    public void setResponseHeaderSize(Integer responseHeaderSize) {
        this.responseHeaderSize = responseHeaderSize;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    @Metadata(description="To use a http proxy to configure the hostname.", label="proxy")
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Metadata(description="To use a http proxy to configure the port number.", label="proxy")
    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean isUseXForwardedForHeader() {
        return this.useXForwardedForHeader;
    }

    @Metadata(description="To use the X-Forwarded-For header in HttpServletRequest.getRemoteAddr.")
    public void setUseXForwardedForHeader(boolean useXForwardedForHeader) {
        this.useXForwardedForHeader = useXForwardedForHeader;
    }

    public boolean isSendServerVersion() {
        return this.sendServerVersion;
    }

    @Metadata(description="If the option is true, jetty will send the server header with the jetty version information to the client which sends the request. NOTE please make sure there is no any other camel-jetty endpoint is share the same port, otherwise this option may not work as expected.", defaultValue="true", label="consumer")
    public void setSendServerVersion(boolean sendServerVersion) {
        this.sendServerVersion = sendServerVersion;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    @Metadata(description="The maximum size allowed for uploaded files. -1 means no limit", defaultValue="-1", label="consumer,advanced")
    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    @Metadata(description="The maximum size allowed for multipart/form-data requests. -1 means no limit", defaultValue="-1", label="consumer,advanced")
    public void setMaxRequestSize(long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public int getFileSizeThreshold() {
        return this.fileSizeThreshold;
    }

    @Metadata(description="The size threshold after which files will be written to disk for multipart/form-data requests. By default the files are not written to disk", defaultValue="0", label="consumer,advanced")
    public void setFileSizeThreshold(int fileSizeThreshold) {
        this.fileSizeThreshold = fileSizeThreshold;
    }

    public String getFilesLocation() {
        return this.filesLocation;
    }

    @Metadata(description="The directory location where files will be store for multipart/form-data requests. By default the files are written in the system temporary folder", label="consumer,advanced")
    public void setFilesLocation(String filesLocation) {
        this.filesLocation = filesLocation;
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, verb, basePath, uriTemplate, configuration, parameters, false);
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, "GET", contextPath, null, configuration, parameters, true);
    }

    Consumer doCreateConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, RestConfiguration configuration, Map<String, Object> parameters, boolean api) throws Exception {
        String contextPath;
        int num;
        Object path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? (String)path + uriTemplate : (String)path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        String scheme = "http";
        String host = "";
        int port = 0;
        RestConfiguration config = configuration;
        if (config == null) {
            config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), (String)"jetty");
        }
        if (config.getScheme() != null) {
            scheme = config.getScheme();
        }
        if (config.getHost() != null) {
            host = config.getHost();
        }
        if ((num = config.getPort()) > 0) {
            port = num;
        }
        if (ObjectHelper.isNotEmpty((String)(contextPath = config.getContextPath()))) {
            contextPath = FileUtil.stripTrailingSeparator((String)contextPath);
            if (ObjectHelper.isNotEmpty((String)(contextPath = FileUtil.stripLeadingSeparator((String)contextPath)))) {
                path = contextPath + "/" + (String)path;
            }
        }
        if (ObjectHelper.isEmpty((String)host)) {
            host = RestComponentHelper.resolveRestHostName((String)host, (RestConfiguration)config);
        }
        Map map = RestComponentHelper.initRestEndpointProperties((String)"jetty", (RestConfiguration)config);
        boolean cors = config.isEnableCORS();
        if (cors) {
            map.put("optionsEnabled", "true");
        }
        if (api) {
            map.put("matchOnUriPrefix", "true");
        }
        RestComponentHelper.addHttpRestrictParam((Map)map, (String)verb, (boolean)cors);
        String url = RestComponentHelper.createRestConsumerUrl((String)"jetty", (String)scheme, (String)host, (int)port, (String)path, (Map)map);
        JettyHttpEndpoint endpoint = (JettyHttpEndpoint)camelContext.getEndpoint(url, parameters);
        if (!map.containsKey("httpBindingRef")) {
            endpoint.setHttpBinding((HttpBinding)new JettyRestHttpBinding(endpoint));
            endpoint.setEnableMultipartFilter(false);
        }
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(camelContext, consumer, config.getConsumerProperties());
        }
        ServiceHelper.startService((Service)endpoint);
        return consumer;
    }

    protected CamelServlet createServletForConnector(Server server, Connector connector, List<Handler> handlers, JettyHttpEndpoint endpoint) throws Exception {
        ServletContextHandler context = new ServletContextHandler("/", false, false);
        server.setHandler((Handler)context);
        this.addJettyHandlers(server, handlers);
        CamelContinuationServlet camelServlet = new CamelContinuationServlet();
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)camelServlet);
        holder.setAsyncSupported(true);
        holder.setInitParameter("async", Boolean.toString(endpoint.isAsync()));
        context.addServlet(holder, "/*");
        String location = endpoint.getFilesLocation();
        if (location == null) {
            File file = File.createTempFile("camel", "");
            if (!FileUtil.deleteFile((File)file)) {
                LOG.error("failed to delete {}", (Object)file);
            }
            location = file.getParentFile().getAbsolutePath();
        }
        holder.getRegistration().setMultipartConfig(new MultipartConfigElement(location, endpoint.getMaxFileSize().longValue(), endpoint.getMaxRequestSize().longValue(), endpoint.getFileSizeThreshold().intValue()));
        camelServlet.setServletResolveConsumerStrategy((ServletResolveConsumerStrategy)new HttpRestServletResolveConsumerStrategy());
        return camelServlet;
    }

    protected void addJettyHandlers(Server server, List<Handler> handlers) {
        if (handlers != null && !handlers.isEmpty()) {
            for (Handler handler : handlers) {
                if (handler instanceof Handler.Wrapper) {
                    if (this.isHandlerInChain(server.getHandler(), handler)) continue;
                    ((Handler.Wrapper)handler).setHandler(server.getHandler());
                    server.setHandler(handler);
                    continue;
                }
                ContextHandlerCollection handlerCollection = new ContextHandlerCollection(new ContextHandler[0]);
                handlerCollection.addHandler(server.getHandler());
                handlerCollection.addHandler(handler);
                server.setHandler((Handler)handlerCollection);
            }
        }
    }

    protected boolean isHandlerInChain(Handler current, Handler handler) {
        if (handler.equals(current)) {
            return true;
        }
        if (current instanceof Handler.Wrapper) {
            return this.isHandlerInChain(((Handler.Wrapper)current).getHandler(), handler);
        }
        return false;
    }

    protected Server createServer() {
        ThreadPool tp = this.threadPool;
        this.defaultQueuedThreadPool = null;
        if (this.minThreads != null || this.maxThreads != null) {
            if (this.getThreadPool() != null) {
                throw new IllegalArgumentException("You cannot configure both minThreads/maxThreads and a custom threadPool on JettyHttpComponent: " + this);
            }
            this.defaultQueuedThreadPool = new QueuedThreadPool();
            if (this.minThreads != null) {
                this.defaultQueuedThreadPool.setMinThreads(this.minThreads.intValue());
            }
            if (this.maxThreads != null) {
                this.defaultQueuedThreadPool.setMaxThreads(this.maxThreads.intValue());
            }
            tp = this.defaultQueuedThreadPool;
        }
        Server s = tp != null ? new Server(tp) : new Server();
        if (this.isEnableJmx()) {
            this.enableJmx(s);
        }
        if (this.defaultQueuedThreadPool != null) {
            this.defaultQueuedThreadPool.setName("CamelJettyServer(" + ObjectHelper.getIdentityHashCode((Object)s) + ")");
            try {
                this.defaultQueuedThreadPool.start();
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error starting JettyServer thread pool: " + this.defaultQueuedThreadPool, (Throwable)e);
            }
        }
        ContextHandlerCollection collection = new ContextHandlerCollection(new ContextHandler[0]);
        s.setHandler((Handler)collection);
        if (this.getErrorHandler() != null) {
            s.setErrorHandler((Request.Handler)this.getErrorHandler());
        } else {
            ErrorHandler eh = new ErrorHandler(){

                public boolean handle(Request baseRequest, Response response, Callback callback) throws Exception {
                    String msg = HttpStatus.getMessage((int)response.getStatus());
                    Object timeout = baseRequest.getAttribute("CamelTimeoutException");
                    if (Boolean.TRUE.equals(timeout)) {
                        baseRequest.setAttribute("jakarta.servlet.error.status_code", (Object)504);
                        response.setStatus(504);
                    }
                    baseRequest.setAttribute("jakarta.servlet.error.message", (Object)msg);
                    return super.handle(baseRequest, response, callback);
                }
            };
            s.setErrorHandler((Request.Handler)eh);
        }
        return s;
    }

    protected void doInit() throws Exception {
        super.doInit();
        try {
            RestConfiguration config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), (String)"jetty");
            if (config.getComponentProperties() != null && !config.getComponentProperties().isEmpty()) {
                this.setProperties((Object)this, config.getComponentProperties());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (!CONNECTORS.isEmpty()) {
            for (Map.Entry<String, ConnectorRef> connectorEntry : CONNECTORS.entrySet()) {
                ConnectorRef connectorRef = connectorEntry.getValue();
                if (connectorRef == null || connectorRef.getRefCount() != 0) continue;
                connectorRef.server.removeConnector(connectorRef.connector);
                connectorRef.connector.stop();
                this.removeServerMBean(connectorRef.server);
                connectorRef.server.stop();
                CONNECTORS.remove(connectorEntry.getKey());
            }
        }
        if (this.mbContainer != null) {
            this.mbContainer.destroy();
            this.mbContainer = null;
        }
    }

    private void addServerMBean(Server server) {
        if (this.mbContainer == null) {
            return;
        }
        try {
            Container o = JettyHttpComponent.getContainer(server);
            o.getClass().getMethod("addEventListener", EventListener.class).invoke((Object)o, this.mbContainer);
            this.mbContainer.getClass().getMethod("beanAdded", Container.class, Object.class).invoke((Object)this.mbContainer, null, server);
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception r) {
            throw new RuntimeException(r);
        }
    }

    private void removeServerMBean(Server server) {
        try {
            this.mbContainer.getClass().getMethod("beanRemoved", Container.class, Object.class).invoke((Object)this.mbContainer, null, server);
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception r) {
            try {
                this.mbContainer.getClass().getMethod("removeBean", Object.class).invoke((Object)this.mbContainer, server);
            }
            catch (RuntimeException rex) {
                throw rex;
            }
            catch (Exception r2) {
                throw new RuntimeException(r);
            }
        }
    }

    private static Container getContainer(Object server) {
        if (server instanceof Container) {
            return (Container)server;
        }
        try {
            return (Container)server.getClass().getMethod("getContainer", new Class[0]).invoke(server, new Object[0]);
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    static class ConnectorRef {
        final Server server;
        final Connector connector;
        final CamelServlet servlet;
        int refCount;

        ConnectorRef(Server server, Connector connector, CamelServlet servlet) {
            this.server = server;
            this.connector = connector;
            this.servlet = servlet;
            this.increment();
        }

        public int increment() {
            return ++this.refCount;
        }

        public int decrement() {
            return --this.refCount;
        }

        public int getRefCount() {
            return this.refCount;
        }
    }
}

