/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.http.common.CamelServlet;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpMessage;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public class CamelContinuationServlet
extends CamelServlet {
    static final String TIMEOUT_ERROR = "CamelTimeoutException";
    static final String EXCHANGE_ATTRIBUTE_NAME = "CamelExchange";
    static final String EXCHANGE_ATTRIBUTE_ID = "CamelExchangeId";
    private static final long serialVersionUID = 1L;
    private final Map<String, String> expiredExchanges = new ConcurrentHashMap<String, String>();

    protected void doService(HttpServletRequest request, HttpServletResponse response) {
        this.log.trace("Service: {}", (Object)request);
        try {
            this.handleDoService(request, response);
        }
        catch (Exception e) {
            this.log.warn("Error handling request due to: " + e.getMessage(), (Throwable)e);
            try {
                if (!response.isCommitted()) {
                    response.sendError(500);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void handleDoService(final HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final HttpConsumer consumer = this.getServletResolveConsumerStrategy().resolve(request, this.getConsumers());
        if (consumer == null) {
            boolean hasAnyMethod = METHODS.stream().anyMatch(m -> this.getServletResolveConsumerStrategy().isHttpMethodAllowed(request, m, this.getConsumers()));
            if (hasAnyMethod) {
                this.log.debug("No consumer to service request {} as method {} is not allowed", (Object)request, (Object)request.getMethod());
                response.sendError(405);
                return;
            }
            this.log.debug("No consumer to service request {} as resource is not found", (Object)request);
            response.sendError(404);
            return;
        }
        boolean useContinuation = false;
        Object continuationTimeout = null;
        HttpCommonEndpoint endpoint = consumer.getEndpoint();
        if (endpoint instanceof JettyHttpEndpoint) {
            JettyHttpEndpoint jettyEndpoint = (JettyHttpEndpoint)endpoint;
            Boolean epUseContinuation = jettyEndpoint.getUseContinuation();
            Long epContinuationTimeout = jettyEndpoint.getContinuationTimeout();
            useContinuation = epUseContinuation != null ? epUseContinuation.booleanValue() : jettyEndpoint.getComponent().isUseContinuation();
            continuationTimeout = epContinuationTimeout != null ? epContinuationTimeout : jettyEndpoint.getComponent().getContinuationTimeout();
        }
        if (!useContinuation) {
            this.log.trace("Usage of continuation is disabled, either by component or endpoint configuration, fallback to normal servlet processing instead");
            super.doService(request, response);
            return;
        }
        this.log.trace("Start request with continuation timeout of {}", continuationTimeout != null ? continuationTimeout : "jetty default");
        if ("OPTIONS".equals(request.getMethod()) && !consumer.isOptionsEnabled()) {
            Object allowedMethods = METHODS.stream().filter(m -> this.getServletResolveConsumerStrategy().isHttpMethodAllowed(request, m, this.getConsumers())).collect(Collectors.joining(","));
            if (allowedMethods == null && consumer.getEndpoint().getHttpMethodRestrict() != null) {
                allowedMethods = consumer.getEndpoint().getHttpMethodRestrict();
            }
            if (allowedMethods == null) {
                allowedMethods = "GET,HEAD,POST,PUT,DELETE,TRACE,OPTIONS,CONNECT,PATCH";
            }
            if (!((String)allowedMethods).contains("OPTIONS")) {
                allowedMethods = (String)allowedMethods + ",OPTIONS";
            }
            response.addHeader("Allow", (String)allowedMethods);
            response.setStatus(200);
            return;
        }
        if (consumer.getEndpoint().getHttpMethodRestrict() != null) {
            Iterator it = ObjectHelper.createIterable((String)consumer.getEndpoint().getHttpMethodRestrict()).iterator();
            boolean match = false;
            while (it.hasNext()) {
                String method = it.next().toString();
                if (!method.equalsIgnoreCase(request.getMethod())) continue;
                match = true;
                break;
            }
            if (!match) {
                response.sendError(405);
                return;
            }
        }
        if ("TRACE".equals(request.getMethod()) && !consumer.isTraceEnabled()) {
            response.sendError(405);
            return;
        }
        String contentType = request.getContentType();
        if ("application/x-java-serialized-object".equals(contentType) && !consumer.getEndpoint().getComponent().isAllowJavaSerializedObject()) {
            response.sendError(415);
            return;
        }
        Exchange result = (Exchange)request.getAttribute(EXCHANGE_ATTRIBUTE_NAME);
        if (result == null) {
            final AsyncContext asyncContext = request.startAsync();
            if (this.isInitial(request) && continuationTimeout != null) {
                asyncContext.setTimeout(((Long)continuationTimeout).longValue());
            }
            asyncContext.addListener((AsyncListener)new ExpiredListener(), (ServletRequest)request, (ServletResponse)response);
            if (consumer.isSuspended() && this.isInitial(request)) {
                response.sendError(503);
                return;
            }
            final Exchange exchange = consumer.createExchange(false);
            exchange.setPattern(ExchangePattern.InOut);
            if (consumer.getEndpoint().isBridgeEndpoint()) {
                exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
                exchange.setProperty("CamelSkipWwwFormUrlEncoding", (Object)Boolean.TRUE);
            }
            if (consumer.getEndpoint().isDisableStreamCache()) {
                exchange.setProperty("CamelDisableHttpStreamCache", (Object)Boolean.TRUE);
            }
            HttpHelper.setCharsetFromContentType((String)request.getContentType(), (Exchange)exchange);
            Message msg = exchange.getIn();
            if (msg instanceof HttpMessage) {
                HttpMessage hm = (HttpMessage)msg;
                hm.init(exchange, endpoint, request, response);
            } else {
                exchange.setIn((Message)new HttpMessage(exchange, endpoint, request, response));
            }
            String contextPath = consumer.getEndpoint().getPath();
            exchange.getIn().setHeader("CamelServletContextPath", (Object)contextPath);
            this.updateHttpPath(exchange, contextPath);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Suspending continuation of exchangeId: {}", (Object)exchange.getExchangeId());
            }
            request.setAttribute(EXCHANGE_ATTRIBUTE_ID, (Object)exchange.getExchangeId());
            UnitOfWork uow = exchange.getUnitOfWork();
            if (uow == null) {
                try {
                    consumer.createUoW(exchange);
                }
                catch (Exception e) {
                    this.log.error("Error processing request", (Throwable)e);
                    throw new ServletException((Throwable)e);
                }
            } else if (uow.onPrepare(exchange)) {
                exchange.getExchangeExtension().setUnitOfWork(uow);
            }
            ClassLoader oldTccl = this.overrideTccl(exchange);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Processing request for exchangeId: {}", (Object)exchange.getExchangeId());
            }
            consumer.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    boolean expired;
                    boolean bl = expired = CamelContinuationServlet.this.expiredExchanges.remove(exchange.getExchangeId()) != null;
                    if (!expired) {
                        if (CamelContinuationServlet.this.log.isTraceEnabled()) {
                            CamelContinuationServlet.this.log.trace("Resuming continuation of exchangeId: {}", (Object)exchange.getExchangeId());
                        }
                        request.setAttribute(CamelContinuationServlet.EXCHANGE_ATTRIBUTE_NAME, (Object)exchange);
                        asyncContext.dispatch();
                    } else {
                        CamelContinuationServlet.this.log.warn("Cannot resume expired continuation of exchangeId: {}", (Object)exchange.getExchangeId());
                        consumer.releaseExchange(exchange, false);
                    }
                }
            });
            if (oldTccl != null) {
                this.restoreTccl(exchange, oldTccl);
            }
            return;
        }
        try {
            Integer bs;
            if (this.log.isTraceEnabled()) {
                this.log.trace("Resumed continuation and writing response for exchangeId: {}", (Object)result.getExchangeId());
            }
            if ((bs = consumer.getEndpoint().getResponseBufferSize()) != null) {
                this.log.trace("Using response buffer size: {}", (Object)bs);
                response.setBufferSize(bs.intValue());
            }
            consumer.getBinding().writeResponse(result, response);
        }
        catch (IOException e) {
            this.log.error("Error processing request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error("Error processing request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            consumer.doneUoW(result);
            consumer.releaseExchange(result, false);
        }
    }

    private boolean isInitial(HttpServletRequest request) {
        return request.getDispatcherType() != DispatcherType.ASYNC;
    }

    private void updateHttpPath(Exchange exchange, String contextPath) {
        String httpPath = (String)exchange.getIn().getHeader("CamelHttpPath");
        String encodedContextPath = UnsafeUriCharactersEncoder.encodeHttpURI((String)contextPath);
        if (contextPath != null && httpPath.startsWith(encodedContextPath)) {
            exchange.getIn().setHeader("CamelHttpPath", (Object)httpPath.substring(encodedContextPath.length()));
        }
    }

    public void destroy() {
        this.expiredExchanges.clear();
        super.destroy();
    }

    private class ExpiredListener
    implements AsyncListener {
        private ExpiredListener() {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            HttpServletRequest request = (HttpServletRequest)event.getSuppliedRequest();
            String id = (String)request.getAttribute(CamelContinuationServlet.EXCHANGE_ATTRIBUTE_ID);
            CamelContinuationServlet.this.expiredExchanges.put(id, id);
            CamelContinuationServlet.this.log.warn("Continuation expired of exchangeId: {}", (Object)id);
            request.setAttribute(CamelContinuationServlet.TIMEOUT_ERROR, (Object)Boolean.TRUE);
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }
    }
}

