/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.http.common.DefaultHttpBinding;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.http.common.HttpMessage;

public class JettyRestHttpBinding
extends DefaultHttpBinding {
    @Deprecated
    public JettyRestHttpBinding() {
    }

    public JettyRestHttpBinding(HttpCommonEndpoint ep) {
        super(ep);
        this.setHeaderFilterStrategy(ep.getHeaderFilterStrategy());
        this.setTransferException(ep.isTransferException());
        this.setEagerCheckContentAvailable(ep.isEagerCheckContentAvailable());
        this.setMapHttpMessageBody(ep.isMapHttpMessageBody());
        this.setMapHttpMessageHeaders(ep.isMapHttpMessageHeaders());
    }

    protected void populateRequestParameters(HttpServletRequest request, HttpMessage message) {
        super.populateRequestParameters(request, message);
        String path = request.getPathInfo();
        if (path == null) {
            return;
        }
        JettyHttpEndpoint endpoint = (JettyHttpEndpoint)message.getExchange().getFromEndpoint();
        String consumerPath = endpoint.getPath();
        if (this.useRestMatching(consumerPath)) {
            HttpHelper.evalPlaceholders((Map)message.getHeaders(), (String)path, (String)consumerPath);
        }
    }

    private boolean useRestMatching(String path) {
        return path.indexOf(123) > -1;
    }
}

