/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jdbc.JdbcEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcComponent
extends DefaultComponent<DefaultExchange> {
    private DataSource ds;

    public JdbcComponent() {
    }

    public JdbcComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint<DefaultExchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        DataSource dataSource;
        if (this.ds != null) {
            dataSource = this.ds;
        } else {
            dataSource = (DataSource)this.getCamelContext().getRegistry().lookup(remaining, DataSource.class);
            if (dataSource == null) {
                throw new IllegalArgumentException("DataSource " + remaining + " not found in registry");
            }
        }
        JdbcEndpoint jdbc = new JdbcEndpoint(uri, (Component)this, dataSource);
        this.setProperties((Object)jdbc, parameters);
        return jdbc;
    }

    public void setDataSource(DataSource dataSource) {
        this.ds = dataSource;
    }
}

