/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Value;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.jcr.JcrConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class JcrConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        JcrConverterLoader.addTypeConverter(registry, InputStream.class, Value.class, false, (type, exchange, value) -> {
            InputStream answer = JcrConverter.toValue((Value)value);
            return answer;
        });
        JcrConverterLoader.addTypeConverter(registry, Boolean.class, Value.class, false, (type, exchange, value) -> {
            Boolean answer = JcrConverter.toBoolean((Value)value);
            return answer;
        });
        JcrConverterLoader.addTypeConverter(registry, String.class, Value.class, false, (type, exchange, value) -> {
            String answer = JcrConverter.toString((Value)value);
            return answer;
        });
        JcrConverterLoader.addTypeConverter(registry, Calendar.class, Value.class, false, (type, exchange, value) -> {
            Calendar answer = JcrConverter.toCalendar((Value)value);
            return answer;
        });
        JcrConverterLoader.addTypeConverter(registry, Value.class, InputStream.class, false, (type, exchange, value) -> {
            Value answer = JcrConverter.toValue((InputStream)value);
            return answer;
        });
        JcrConverterLoader.addTypeConverter(registry, Value.class, Boolean.class, false, (type, exchange, value) -> {
            Value answer = JcrConverter.toValue((Boolean)value);
            return answer;
        });
        JcrConverterLoader.addTypeConverter(registry, Value.class, String.class, false, (type, exchange, value) -> {
            Value answer = JcrConverter.toValue((String)value);
            return answer;
        });
        JcrConverterLoader.addTypeConverter(registry, Value.class, Calendar.class, false, (type, exchange, value) -> {
            Value answer = JcrConverter.toValue((Calendar)value);
            return answer;
        });
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

