/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.jcr.EndpointEventListener;
import org.apache.camel.component.jcr.JcrEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(JcrConsumer.class);
    private Session session;
    private EventListener eventListener;
    private ScheduledFuture<?> sessionListenerCheckerScheduledFuture;

    public JcrConsumer(JcrEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.scheduleSessionListenerChecker();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.cancelSessionListenerChecker();
        this.unregisterListenerAndLogoutSession();
    }

    protected JcrEndpoint getJcrEndpoint() {
        return (JcrEndpoint)this.getEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSessionAndRegisterListener() throws RepositoryException {
        this.lock.lock();
        try {
            LOG.trace("createSessionAndRegisterListener START");
            this.session = ObjectHelper.isEmpty((String)this.getJcrEndpoint().getWorkspaceName()) ? this.getJcrEndpoint().getRepository().login(this.getJcrEndpoint().getCredentials()) : this.getJcrEndpoint().getRepository().login(this.getJcrEndpoint().getCredentials(), this.getJcrEndpoint().getWorkspaceName());
            int eventTypes = this.getJcrEndpoint().getEventTypes();
            Object absPath = this.getJcrEndpoint().getBase();
            if (absPath == null) {
                absPath = "/";
            } else if (!((String)absPath).startsWith("/")) {
                absPath = "/" + (String)absPath;
            }
            boolean isDeep = this.getJcrEndpoint().isDeep();
            Object[] uuid = null;
            String uuids = this.getJcrEndpoint().getUuids();
            if (uuids != null && !(uuids = uuids.trim()).isEmpty()) {
                uuid = uuids.split(",");
            }
            Object[] nodeTypeName = null;
            String nodeTypeNames = this.getJcrEndpoint().getNodeTypeNames();
            if (nodeTypeNames != null && !(nodeTypeNames = nodeTypeNames.trim()).isEmpty()) {
                nodeTypeName = nodeTypeNames.split(",");
            }
            boolean noLocal = this.getJcrEndpoint().isNoLocal();
            this.eventListener = new EndpointEventListener(this, this.getJcrEndpoint(), this.getProcessor());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding JCR Event Listener, {}, on {}. eventTypes={}, isDeep={}, uuid={}, nodeTypeName={}, noLocal={}", new Object[]{this.eventListener, absPath, eventTypes, isDeep, Arrays.toString(uuid), Arrays.toString(nodeTypeName), noLocal});
            }
            this.session.getWorkspace().getObservationManager().addEventListener(this.eventListener, eventTypes, (String)absPath, isDeep, (String[])uuid, (String[])nodeTypeName, noLocal);
            LOG.trace("createSessionAndRegisterListener END");
        }
        finally {
            this.lock.unlock();
        }
    }

    private void unregisterListenerAndLogoutSession() throws RepositoryException {
        this.lock.lock();
        try {
            LOG.trace("unregisterListenerAndLogoutSession START");
            if (this.session != null) {
                try {
                    if (!this.session.isLive()) {
                        LOG.info("Session was is no more live.");
                    } else {
                        if (this.eventListener != null) {
                            this.session.getWorkspace().getObservationManager().removeEventListener(this.eventListener);
                            this.eventListener = null;
                        }
                        this.session.logout();
                    }
                }
                finally {
                    this.eventListener = null;
                    this.session = null;
                }
            }
            LOG.trace("unregisterListenerAndLogoutSession END");
        }
        finally {
            this.lock.unlock();
        }
    }

    private void cancelSessionListenerChecker() {
        if (this.sessionListenerCheckerScheduledFuture != null) {
            this.sessionListenerCheckerScheduledFuture.cancel(true);
        }
    }

    private void scheduleSessionListenerChecker() {
        String name = "JcrConsumerSessionChecker[" + this.getJcrEndpoint().getEndpointConfiguredDestinationName() + "]";
        ScheduledExecutorService executor = this.getJcrEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, name);
        JcrConsumerSessionListenerChecker sessionListenerChecker = new JcrConsumerSessionListenerChecker();
        long sessionLiveCheckIntervalOnStart = this.getJcrEndpoint().getSessionLiveCheckIntervalOnStart();
        long sessionLiveCheckInterval = this.getJcrEndpoint().getSessionLiveCheckInterval();
        this.sessionListenerCheckerScheduledFuture = executor.scheduleWithFixedDelay(sessionListenerChecker, sessionLiveCheckIntervalOnStart, sessionLiveCheckInterval, TimeUnit.MILLISECONDS);
    }

    private class JcrConsumerSessionListenerChecker
    implements Runnable {
        private JcrConsumerSessionListenerChecker() {
        }

        @Override
        public void run() {
            LOG.debug("JcrConsumerSessionListenerChecker starts.");
            boolean isSessionLive = false;
            JcrConsumer.this.lock.lock();
            try {
                if (JcrConsumer.this.session != null) {
                    try {
                        isSessionLive = JcrConsumer.this.session.isLive();
                    }
                    catch (Exception e) {
                        LOG.debug("Exception while checking jcr session", (Throwable)e);
                    }
                }
            }
            finally {
                JcrConsumer.this.lock.unlock();
            }
            if (!isSessionLive) {
                try {
                    JcrConsumer.this.createSessionAndRegisterListener();
                }
                catch (RepositoryException e) {
                    LOG.error("Failed to create session and register listener", (Throwable)e);
                }
            }
            LOG.debug("JcrConsumerSessionListenerChecker stops.");
        }
    }
}

