/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import java.net.URI;
import java.net.URISyntaxException;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.SimpleCredentials;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jcr.JcrComponent;
import org.apache.camel.component.jcr.JcrConstants;
import org.apache.camel.component.jcr.JcrConsumer;
import org.apache.camel.component.jcr.JcrProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

@UriEndpoint(firstVersion="1.3.0", scheme="jcr", title="JCR", syntax="jcr:host/base", alternativeSyntax="jcr:username:password@host/base", category={Category.DATABASE, Category.CMS}, headersClass=JcrConstants.class)
public class JcrEndpoint
extends DefaultEndpoint {
    private Credentials credentials;
    private Repository repository;
    @UriPath
    @Metadata(required=true)
    private String host;
    @UriPath
    private String base;
    @UriParam
    private String username;
    @UriParam
    private String password;
    @UriParam
    private int eventTypes;
    @UriParam
    private boolean deep;
    @UriParam
    private String uuids;
    @UriParam
    private String nodeTypeNames;
    @UriParam
    private boolean noLocal;
    @UriParam(defaultValue="3000", javaType="java.time.Duration")
    private long sessionLiveCheckIntervalOnStart = 3000L;
    @UriParam(defaultValue="60000", javaType="java.time.Duration")
    private long sessionLiveCheckInterval = 60000L;
    @UriParam
    private String workspaceName;

    protected JcrEndpoint(String endpointUri, JcrComponent component) {
        super(endpointUri, (Component)component);
        try {
            URI uri = new URI(endpointUri);
            if (uri.getUserInfo() != null) {
                String[] creds = uri.getUserInfo().split(":");
                this.username = creds[0];
                this.password = creds.length > 1 ? creds[1] : "";
            }
            this.host = uri.getHost();
            this.base = uri.getPath().replaceAll("^/", "");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + endpointUri, e);
        }
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        JcrConsumer answer = new JcrConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        return new JcrProducer(this);
    }

    protected void doStart() throws Exception {
        super.doStart();
        StringHelper.notEmpty((String)this.host, (String)"host", (Object)((Object)this));
        this.repository = (Repository)this.getCamelContext().getRegistry().lookupByNameAndType(this.host, Repository.class);
        if (this.repository == null) {
            throw new RuntimeCamelException("No JCR repository defined under '" + this.host + "'");
        }
        if (this.username != null && this.password != null) {
            this.credentials = new SimpleCredentials(this.username, this.password.toCharArray());
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected Credentials getCredentials() {
        return this.credentials;
    }

    protected String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(int eventTypes) {
        this.eventTypes = eventTypes;
    }

    public boolean isDeep() {
        return this.deep;
    }

    public void setDeep(boolean deep) {
        this.deep = deep;
    }

    public String getUuids() {
        return this.uuids;
    }

    public void setUuids(String uuids) {
        this.uuids = uuids;
    }

    public String getNodeTypeNames() {
        return this.nodeTypeNames;
    }

    public void setNodeTypeNames(String nodeTypeNames) {
        this.nodeTypeNames = nodeTypeNames;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public long getSessionLiveCheckIntervalOnStart() {
        return this.sessionLiveCheckIntervalOnStart;
    }

    public void setSessionLiveCheckIntervalOnStart(long sessionLiveCheckIntervalOnStart) {
        if (sessionLiveCheckIntervalOnStart <= 0L) {
            throw new IllegalArgumentException("sessionLiveCheckIntervalOnStart must be positive value");
        }
        this.sessionLiveCheckIntervalOnStart = sessionLiveCheckIntervalOnStart;
    }

    public long getSessionLiveCheckInterval() {
        return this.sessionLiveCheckInterval;
    }

    public void setSessionLiveCheckInterval(long sessionLiveCheckInterval) {
        if (sessionLiveCheckInterval <= 0L) {
            throw new IllegalArgumentException("sessionLiveCheckInterval must be positive value");
        }
        this.sessionLiveCheckInterval = sessionLiveCheckInterval;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public String getEndpointConfiguredDestinationName() {
        String remainder = StringHelper.after((String)this.getEndpointKey(), (String)"//");
        if (remainder != null && remainder.contains("@")) {
            remainder = remainder.substring(remainder.indexOf(64));
        }
        if (remainder != null && remainder.contains("?")) {
            remainder = StringHelper.before((String)remainder, (String)"?");
        }
        if (ObjectHelper.isEmpty((String)remainder)) {
            return remainder;
        }
        return remainder;
    }
}

