/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Route;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.component.kamelet.KameletEndpoint;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.support.Capability;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.support.SourceMetadata;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.support.StubComponentResolver;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.support.StubDataFormatResolver;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.support.StubLanguageResolver;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.support.StubTransformerResolver;
import org.apache.camel.dsl.jbang.core.common.Source;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultModelReifierFactory;
import org.apache.camel.main.download.CamelCustomClassLoader;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.main.download.DependencyDownloaderClassResolver;
import org.apache.camel.main.download.DependencyDownloaderRoutesLoader;
import org.apache.camel.main.download.DependencyDownloaderStrategy;
import org.apache.camel.main.download.KnownDependenciesResolver;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.model.CircuitBreakerDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.reifier.DisabledReifier;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.ModelReifierFactory;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.spi.TransformerResolver;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.util.URISupport;

public class MetadataHelper {
    public static final String STUB_PATTERN = "*";
    private static final Map<String, BiConsumer<CamelCatalog, SourceMetadata>> COMPONENT_CUSTOMIZERS;

    private MetadataHelper() {
    }

    public static SourceMetadata readFromSource(CamelCatalog catalog, Source source) throws Exception {
        return MetadataHelper.readFromSource(catalog, source.name(), source.content());
    }

    public static SourceMetadata readFromSource(CamelCatalog catalog, String location, String source) throws Exception {
        CamelContext context = MetadataHelper.createCamelContext();
        try {
            Resource resource = ResourceHelper.fromString((String)location, (String)source);
            try {
                PluginHelper.getRoutesLoader((CamelContext)context).loadRoutes(new Resource[]{resource});
            }
            catch (IllegalArgumentException e) {
                SourceMetadata sourceMetadata = new SourceMetadata();
                if (context != null) {
                    context.close();
                }
                return sourceMetadata;
            }
            context.start();
            Model model = (Model)context.getCamelContextExtension().getContextPlugin(Model.class);
            Set fromEndpoints = model.getRouteDefinitions().stream().map(RouteDefinition::getInput).map(FromDefinition::getEndpointUri).map(arg_0 -> ((CamelContext)context).getEndpoint(arg_0)).map(Endpoint::getEndpointUri).collect(Collectors.toSet());
            Set toEndpoints = context.getEndpoints().stream().map(Endpoint::getEndpointUri).filter(Predicate.not(fromEndpoints::contains)).collect(Collectors.toSet());
            Set kamelets = context.getEndpoints().stream().filter(KameletEndpoint.class::isInstance).map(KameletEndpoint.class::cast).map(KameletEndpoint::getTemplateId).collect(Collectors.toSet());
            SourceMetadata meta = new SourceMetadata();
            meta.resources.components.addAll(context.getComponentNames());
            meta.resources.languages.addAll(context.getLanguageNames());
            meta.resources.dataformats.addAll(context.getDataFormatNames());
            meta.resources.kamelets.addAll(kamelets);
            meta.endpoints.from.addAll(fromEndpoints);
            meta.endpoints.to.addAll(toEndpoints);
            for (String component : meta.resources.components) {
                BiConsumer<CamelCatalog, SourceMetadata> consumer = COMPONENT_CUSTOMIZERS.get(component);
                if (consumer == null) continue;
                consumer.accept(catalog, meta);
            }
            for (RouteDefinition definition : model.getRouteDefinitions()) {
                MetadataHelper.navigateRoute(definition, d -> {
                    if (d instanceof CircuitBreakerDefinition) {
                        meta.capabilities.add(Capability.CircuitBreaker);
                    }
                });
            }
            meta.dependencies.addAll(MetadataHelper.deps(context, catalog));
            SourceMetadata sourceMetadata = meta;
            return sourceMetadata;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private static Collection<String> deps(CamelContext context, CamelCatalog catalog) {
        ComponentModel model;
        TreeSet<String> answer = new TreeSet<String>();
        for (String name : context.getComponentNames()) {
            model = catalog.componentModel(name);
            if (model == null) continue;
            answer.add(String.format("mvn:%s/%s/%s", model.getGroupId(), model.getArtifactId(), model.getVersion()));
        }
        for (String name : context.getLanguageNames()) {
            model = catalog.languageModel(name);
            if (model == null) continue;
            answer.add(String.format("mvn:%s/%s/%s", model.getGroupId(), model.getArtifactId(), model.getVersion()));
        }
        for (String name : context.getDataFormatNames()) {
            model = catalog.dataFormatModel(name);
            if (model == null) continue;
            answer.add(String.format("mvn:%s/%s/%s", model.getGroupId(), model.getArtifactId(), model.getVersion()));
        }
        return answer;
    }

    private static CamelContext createCamelContext() throws Exception {
        StubComponentResolver componentResolver = new StubComponentResolver(STUB_PATTERN, true);
        final StubDataFormatResolver dataFormatResolver = new StubDataFormatResolver(STUB_PATTERN, true);
        StubLanguageResolver languageResolver = new StubLanguageResolver(STUB_PATTERN, true);
        StubTransformerResolver transformerResolver = new StubTransformerResolver(STUB_PATTERN, true);
        DefaultCamelContext context = new DefaultCamelContext(false){

            public Set<String> getDataFormatNames() {
                return dataFormatResolver.getNames();
            }

            public PropertiesComponent getPropertiesComponent() {
                return new org.apache.camel.component.properties.PropertiesComponent(){

                    public Optional<String> resolveProperty(String key) {
                        return Optional.of(key);
                    }

                    public String parseUri(String uri, boolean keepUnresolvedOptional) {
                        return URISupport.stripQuery((String)uri);
                    }
                };
            }
        };
        ExtendedCamelContext ec = context.getCamelContextExtension();
        Model model = (Model)ec.getContextPlugin(Model.class);
        model.setModelReifierFactory((ModelReifierFactory)new AgentModelReifierFactory());
        ec.addContextPlugin(ComponentResolver.class, (Object)componentResolver);
        ec.addContextPlugin(DataFormatResolver.class, (Object)dataFormatResolver);
        ec.addContextPlugin(LanguageResolver.class, (Object)languageResolver);
        ec.addContextPlugin(TransformerResolver.class, (Object)transformerResolver);
        ec.getRegistry().bind(DependencyDownloaderStrategy.class.getSimpleName(), (Object)new DependencyDownloaderStrategy((CamelContext)context));
        ClassLoader cl = MetadataHelper.createClassLoader((CamelContext)context);
        context.setApplicationContextClassLoader(cl);
        PluginHelper.getPackageScanClassResolver((CamelContext)context).addClassLoader(cl);
        PluginHelper.getPackageScanResourceResolver((CamelContext)context).addClassLoader(cl);
        DependencyDownloaderClassResolver classResolver = new DependencyDownloaderClassResolver((CamelContext)context, new KnownDependenciesResolver((CamelContext)context, "3.5.7", "3.26.4"), true);
        context.setClassResolver((ClassResolver)classResolver);
        FactoryFinderResolver ffr = PluginHelper.getFactoryFinderResolver((CamelContext)context);
        FactoryFinder ff = ffr.resolveBootstrapFactoryFinder((ClassResolver)classResolver);
        context.getCamelContextExtension().setBootstrapFactoryFinder(ff);
        ff = ffr.resolveDefaultFactoryFinder((ClassResolver)classResolver);
        context.getCamelContextExtension().setDefaultFactoryFinder(ff);
        MavenDependencyDownloader downloader = new MavenDependencyDownloader();
        downloader.setClassLoader(cl);
        downloader.setCamelContext((CamelContext)context);
        downloader.setVerbose(false);
        context.addService((Object)downloader);
        DependencyDownloaderRoutesLoader routesLoader = new DependencyDownloaderRoutesLoader((CamelContext)context, VersionHelper.extractCamelVersion(), VersionHelper.extractKameletsVersion());
        ec.addContextPlugin(RoutesLoader.class, (Object)routesLoader);
        context.build();
        return context;
    }

    private static void navigateRoute(ProcessorDefinition<?> root, Consumer<ProcessorDefinition<?>> consumer) {
        consumer.accept(root);
        for (ProcessorDefinition def : root.getOutputs()) {
            MetadataHelper.navigateRoute(def, consumer);
        }
    }

    public static boolean exposesHttpServices(CamelCatalog catalog, SourceMetadata sourceMetadata) {
        for (String uri : sourceMetadata.endpoints.from) {
            String componentName = catalog.endpointComponentName(uri);
            if (componentName == null) continue;
            if (catalog.componentModel(componentName).isConsumerOnly() && componentName.contains("http")) {
                return true;
            }
            if (!componentName.equals("knative")) continue;
            return true;
        }
        return false;
    }

    private static ClassLoader createClassLoader(CamelContext context) {
        return new DependencyDownloaderClassLoader((ClassLoader)new CamelCustomClassLoader(MetadataHelper.class.getClassLoader(), context));
    }

    static {
        ProcessorReifier.registerReifier(CircuitBreakerDefinition.class, DisabledReifier::new);
        COMPONENT_CUSTOMIZERS = new HashMap<String, BiConsumer<CamelCatalog, SourceMetadata>>();
        COMPONENT_CUSTOMIZERS.put(Capability.PlatformHttp.getValue(), (catalog, meta) -> meta.capabilities.add(Capability.PlatformHttp));
    }

    private static final class AgentModelReifierFactory
    extends DefaultModelReifierFactory {
        private AgentModelReifierFactory() {
        }

        public Route createRoute(CamelContext camelContext, Object routeDefinition) {
            if (routeDefinition instanceof RouteDefinition) {
                ((RouteDefinition)routeDefinition).autoStartup(false);
            }
            return super.createRoute(camelContext, routeDefinition);
        }
    }
}

