/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"ingressClass", "annotations", "auto", "enabled", "host", "path", "pathType", "tlsHosts", "tlsSecretName"})
public class Ingress {
    @JsonProperty(value="ingressClass")
    @JsonPropertyDescription(value="To configure the ingress class (default to `nginx`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String ingressClass;
    @JsonProperty(value="annotations")
    @JsonPropertyDescription(value="The annotations added to the ingress. This can be used to set controller specific annotations, e.g., when using the NGINX Ingress controller: See https://github.com/kubernetes/ingress-nginx/blob/main/docs/user-guide/nginx-configuration/annotations.md")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> annotations;
    @JsonProperty(value="auto")
    @JsonPropertyDescription(value="To automatically add an ingress whenever the camel route uses an HTTP endpoint consumer.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean auto;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Can be used to enable or disable a trait.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="To configure the host exposed by the ingress.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String host;
    @JsonProperty(value="path")
    @JsonPropertyDescription(value="To configure the path exposed by the ingress (default `/`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String path;
    @JsonProperty(value="pathType")
    @JsonPropertyDescription(value="To configure the path type exposed by the ingress. One of `Exact`, `Prefix`, `ImplementationSpecific` (default to `Prefix`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private PathType pathType;
    @JsonProperty(value="tlsHosts")
    @JsonPropertyDescription(value="To configure tls hosts")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> tlsHosts;
    @JsonProperty(value="tlsSecretName")
    @JsonPropertyDescription(value="To configure tls secret name")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsSecretName;

    public String getIngressClass() {
        return this.ingressClass;
    }

    public void setIngressClass(String ingressClass) {
        this.ingressClass = ingressClass;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public Boolean getAuto() {
        return this.auto;
    }

    public void setAuto(Boolean auto) {
        this.auto = auto;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public void setPathType(PathType pathType) {
        this.pathType = pathType;
    }

    public List<String> getTlsHosts() {
        return this.tlsHosts;
    }

    public void setTlsHosts(List<String> tlsHosts) {
        this.tlsHosts = tlsHosts;
    }

    public String getTlsSecretName() {
        return this.tlsSecretName;
    }

    public void setTlsSecretName(String tlsSecretName) {
        this.tlsSecretName = tlsSecretName;
    }

    public static enum PathType {
        EXACT("Exact"),
        PREFIX("Prefix"),
        IMPLEMENTATIONSPECIFIC("ImplementationSpecific");

        private final String value;

        private PathType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

