/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.dsl.jbang.core.common.CatalogLoader;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;

public class CatalogHelper {
    private CatalogHelper() {
    }

    public static CamelCatalog loadCatalog(RuntimeType runtime, String runtimeVersion, boolean download) throws Exception {
        return CatalogHelper.loadCatalog(runtime, runtimeVersion, "", null, download);
    }

    public static CamelCatalog loadCatalog(RuntimeType runtime, String runtimeVersion, String repos, String quarkusGroupId, boolean download) throws Exception {
        switch (runtime) {
            case springBoot: {
                return CatalogLoader.loadSpringBootCatalog((String)repos, (String)runtimeVersion, (boolean)download);
            }
            case quarkus: {
                return CatalogLoader.loadQuarkusCatalog((String)repos, (String)runtimeVersion, (String)quarkusGroupId, (boolean)download);
            }
            case main: {
                return CatalogLoader.loadCatalog((String)repos, (String)runtimeVersion, (boolean)download);
            }
        }
        throw new IllegalArgumentException("Unsupported runtime: " + String.valueOf(runtime));
    }
}

