/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model;

import java.util.List;
import java.util.Map;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Ingress;

public final class IngressBuilder {
    private Map<String, String> annotations;
    private Boolean auto;
    private Boolean enabled;
    private String host;
    private String path;
    private Ingress.PathType pathType;
    private List<String> tlsHosts;
    private String tlsSecretName;

    private IngressBuilder() {
    }

    public static IngressBuilder ingress() {
        return new IngressBuilder();
    }

    public IngressBuilder withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public IngressBuilder withAuto(Boolean auto) {
        this.auto = auto;
        return this;
    }

    public IngressBuilder withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public IngressBuilder withHost(String host) {
        this.host = host;
        return this;
    }

    public IngressBuilder withPath(String path) {
        this.path = path;
        return this;
    }

    public IngressBuilder withPathType(Ingress.PathType pathType) {
        this.pathType = pathType;
        return this;
    }

    public IngressBuilder withTlsHosts(List<String> tlsHosts) {
        this.tlsHosts = tlsHosts;
        return this;
    }

    public IngressBuilder withTlsSecretName(String tlsSecretName) {
        this.tlsSecretName = tlsSecretName;
        return this;
    }

    public Ingress build() {
        Ingress ingress = new Ingress();
        ingress.setAnnotations(this.annotations);
        ingress.setAuto(this.auto);
        ingress.setEnabled(this.enabled);
        ingress.setHost(this.host);
        ingress.setPath(this.path);
        ingress.setPathType(this.pathType);
        ingress.setTlsHosts(this.tlsHosts);
        ingress.setTlsSecretName(this.tlsSecretName);
        return ingress;
    }
}

