/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.knative;

import io.fabric8.knative.serving.v1.RevisionTemplateSpecFluent;
import io.fabric8.knative.serving.v1.ServiceBuilder;
import io.fabric8.knative.serving.v1.ServiceFluent;
import io.fabric8.knative.serving.v1.ServiceSpecFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.HashMap;
import java.util.Optional;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.knative.KnativeBaseTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.KnativeService;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Traits;
import org.apache.camel.util.ObjectHelper;

public class KnativeServiceTrait
extends KnativeBaseTrait {
    private static final String knativeServingClassAnnotation = "autoscaling.knative.dev/class";
    private static final String knativeServingMetricAnnotation = "autoscaling.knative.dev/metric";
    private static final String knativeServingTargetAnnotation = "autoscaling.knative.dev/target";
    private static final String knativeServingMinScaleAnnotation = "autoscaling.knative.dev/minScale";
    private static final String knativeServingMaxScaleAnnotation = "autoscaling.knative.dev/maxScale";
    private static final String knativeServingRolloutDurationAnnotation = "serving.knative.dev/rolloutDuration";
    private static final String knativeServingVisibilityLabel = "networking.knative.dev/visibility";

    public KnativeServiceTrait() {
        super("knative-service", 1400);
    }

    @Override
    public boolean configure(Traits traitConfig, TraitContext context) {
        if (context.getKnativeService().isPresent()) {
            return false;
        }
        boolean enabled = false;
        if (traitConfig.getKnativeService() != null) {
            enabled = Optional.ofNullable(traitConfig.getKnativeService().getEnabled()).orElse(false);
        }
        return enabled && TraitHelper.exposesHttpService(context);
    }

    @Override
    public void apply(Traits traitConfig, TraitContext context) {
        KnativeService serviceTrait = Optional.ofNullable(traitConfig.getKnativeService()).orElseGet(KnativeService::new);
        HashMap<String, String> serviceAnnotations = new HashMap<String, String>();
        if (ObjectHelper.isNotEmpty((String)serviceTrait.getRolloutDuration())) {
            serviceAnnotations.put(knativeServingRolloutDurationAnnotation, serviceTrait.getRolloutDuration());
        }
        if (serviceTrait.getAnnotations() != null) {
            serviceAnnotations.putAll(serviceTrait.getAnnotations());
        }
        HashMap<String, String> revisionAnnotations = new HashMap<String, String>();
        if (serviceTrait.get_class() != null && ObjectHelper.isNotEmpty((String)serviceTrait.get_class().getValue())) {
            revisionAnnotations.put(knativeServingClassAnnotation, serviceTrait.get_class().getValue());
        }
        if (ObjectHelper.isNotEmpty((String)serviceTrait.getAutoscalingMetric())) {
            revisionAnnotations.put(knativeServingMetricAnnotation, serviceTrait.getAutoscalingMetric());
        }
        if (serviceTrait.getAutoscalingTarget() != null) {
            revisionAnnotations.put(knativeServingTargetAnnotation, serviceTrait.getAutoscalingTarget().toString());
        }
        if (serviceTrait.getMinScale() != null && serviceTrait.getMinScale() > 0L) {
            revisionAnnotations.put(knativeServingMinScaleAnnotation, serviceTrait.getMinScale().toString());
        }
        if (serviceTrait.getMaxScale() != null && serviceTrait.getMaxScale() > 0L) {
            revisionAnnotations.put(knativeServingMaxScaleAnnotation, serviceTrait.getMaxScale().toString());
        }
        HashMap<String, String> serviceLabels = new HashMap<String, String>();
        serviceLabels.put("app.kubernetes.io/name", context.getName());
        serviceLabels.put("bindings.knative.dev/include", "true");
        if (serviceTrait.getVisibility() != null && ObjectHelper.isNotEmpty((String)serviceTrait.getVisibility().getValue())) {
            serviceLabels.put(knativeServingVisibilityLabel, serviceTrait.getVisibility().getValue());
        }
        ServiceBuilder service = (ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.TemplateNested)((RevisionTemplateSpecFluent.MetadataNested)((RevisionTemplateSpecFluent.MetadataNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(context.getName())).addToLabels(serviceLabels)).addToAnnotations(serviceAnnotations)).endMetadata()).withNewSpec().withNewTemplate().withNewMetadata().addToLabels("app.kubernetes.io/name", context.getName())).addToAnnotations(revisionAnnotations)).endMetadata()).endTemplate()).endSpec();
        if (serviceTrait.getTimeoutSeconds() != null && serviceTrait.getTimeoutSeconds() > 0L) {
            ((ServiceFluent.SpecNested)((ServiceSpecFluent.TemplateNested)((RevisionTemplateSpecFluent.SpecNested)service.editSpec().editTemplate().editSpec().withTimeoutSeconds(serviceTrait.getTimeoutSeconds())).endSpec()).endTemplate()).endSpec();
        }
        if (context.getServiceAccount() != null) {
            ((ServiceFluent.SpecNested)((ServiceSpecFluent.TemplateNested)((RevisionTemplateSpecFluent.SpecNested)service.editSpec().editTemplate().editSpec().withServiceAccountName(context.getServiceAccount())).endSpec()).endTemplate()).endSpec();
        }
        context.add((VisitableBuilder<?, ?>)service);
    }
}

