/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.BaseTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Container;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Traits;

public class DeploymentTrait
extends BaseTrait {
    public DeploymentTrait() {
        super("deployment", 900);
    }

    @Override
    public boolean configure(Traits traitConfig, TraitContext context) {
        return true;
    }

    @Override
    public void apply(Traits traitConfig, TraitContext context) {
        DeploymentBuilder deployment = (DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(context.getName())).endMetadata()).withNewSpec().withSelector(((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(Map.of("app.kubernetes.io/name", context.getName()))).build())).endSpec();
        Container containerTrait = Optional.ofNullable(traitConfig.getContainer()).orElseGet(Container::new);
        Optional.ofNullable(containerTrait.getImagePullSecrets()).orElseGet(List::of).forEach(sec -> ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)deployment.editSpec().editOrNewTemplate().editOrNewSpec().addNewImagePullSecret(sec)).endSpec()).endTemplate()).endSpec());
        if (context.getServiceAccount() != null) {
            ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)deployment.editSpec().editOrNewTemplate().editOrNewSpec().withServiceAccountName(context.getServiceAccount())).endSpec()).endTemplate()).endSpec();
        }
        context.add((VisitableBuilder<?, ?>)deployment);
    }
}

