/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.generate;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.common.RuntimeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.RuntimeTypeConverter;
import org.apache.camel.generator.openapi.RestDslGenerator;
import org.apache.camel.generator.openapi.RestDslXmlGenerator;
import org.apache.camel.generator.openapi.RestDslYamlGenerator;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.DefaultGenerator;
import org.openapitools.codegen.config.CodegenConfigurator;
import picocli.CommandLine;

@CommandLine.Command(name="rest", description={"Generate REST DSL source code from OpenApi specification"})
public class CodeRestGenerator
extends CamelCommand {
    @CommandLine.Option(names={"--input"}, required=true, description={"OpenApi specification file name"})
    private String input;
    @CommandLine.Option(names={"--output"}, description={"Output REST DSL file name"})
    private String output;
    @CommandLine.Option(names={"--type"}, description={"REST DSL type (YAML or XML)"}, defaultValue="yaml", completionCandidates=OpenApiTypeCompletionCandidates.class)
    private String type;
    @CommandLine.Option(names={"--routes"}, description={"Generate routes (only in YAML)"})
    private boolean generateRoutes;
    @CommandLine.Option(names={"--dto"}, description={"Generate Java Data Objects"})
    private boolean generateDataObjects;
    @CommandLine.Option(names={"--runtime"}, completionCandidates=RuntimeCompletionCandidates.class, converter={RuntimeTypeConverter.class}, defaultValue="quarkus", description={"Runtime (${COMPLETION-CANDIDATES})"})
    RuntimeType runtime = RuntimeType.quarkus;
    @CommandLine.Option(names={"--package"}, description={"Package for generated Java models"}, defaultValue="model")
    private String packageName;
    @CommandLine.Option(names={"--openapi-version"}, description={"Openapi specification 3.0 or 3.1"}, defaultValue="3.0", completionCandidates=OpenApiVersionCompletionCandidates.class)
    private String openApiVersion = "3.0";

    public CodeRestGenerator(CamelJBangMain main) {
        super(main);
    }

    public Integer doCall() throws Exception {
        File f = new File(this.input);
        if (!f.exists() && !f.isFile()) {
            this.printer().println("Error: Input file " + this.input + " does not exist");
            return 1;
        }
        OpenAPIV3Parser parser = new OpenAPIV3Parser();
        OpenAPI doc = parser.read(this.input);
        Configurator.setRootLevel((Level)Level.OFF);
        try (DefaultCamelContext context = new DefaultCamelContext();){
            String text = null;
            if ("yaml".equalsIgnoreCase(this.type)) {
                text = ((RestDslYamlGenerator)RestDslGenerator.toYaml((OpenAPI)doc).withDtoPackageName(this.generateDataObjects ? this.packageName : null)).generate((CamelContext)context, this.generateRoutes);
            } else if ("xml".equalsIgnoreCase(this.type)) {
                text = ((RestDslXmlGenerator)RestDslGenerator.toXml((OpenAPI)doc).withDtoPackageName(this.generateDataObjects ? this.packageName : null)).generate((CamelContext)context);
            }
            if (text != null) {
                if (this.output == null) {
                    this.printer().println(text);
                } else {
                    Files.write(Paths.get(this.output, new String[0]), text.getBytes(), new OpenOption[0]);
                }
            }
        }
        if (this.generateDataObjects) {
            this.generateDto();
        }
        return 0;
    }

    private void generateDto() throws IOException {
        String code = "code";
        String generatorName = RuntimeType.quarkus.equals((Object)this.runtime) ? "jaxrs-spec" : "java-camel";
        String library = RuntimeType.quarkus.equals((Object)this.runtime) ? "quarkus" : "spring-boot";
        File output = Files.createTempDirectory("gendto", new FileAttribute[0]).toFile();
        CodegenConfigurator configurator = new CodegenConfigurator().setGeneratorName(generatorName).setLibrary(library).setInputSpec(this.input).setModelPackage(this.packageName).setAdditionalProperties(Map.of("serializableModel", "false", "useJakartaEe", "false", "useSwaggerAnnotations", "false", "generateModels", "true", "generatePom", "false", "generateApis", "false", "sourceFolder", "code")).setOutputDir(output.getAbsolutePath());
        ClientOptInput clientOptInput = configurator.toClientOptInput();
        new DefaultGenerator().opts(clientOptInput).generate();
        File generated = new File(Paths.get(output.getAbsolutePath(), "code", this.packageName).toUri());
        generated.renameTo(new File(this.packageName));
    }

    public static class OpenApiTypeCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("xml", "yaml").iterator();
        }
    }

    public static class OpenApiVersionCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("3.0", "3.1").iterator();
        }
    }
}

