/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.generate;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import java.util.List;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.main.download.MavenDependencyDownloader;
import picocli.CommandLine;

@CommandLine.Command(name="schema", description={"Create a JSON schema for a given Camel component and Java Object"})
public class CodeSchemaGenerator
extends CamelCommand {
    @CommandLine.Parameters(description={"Camel component name (e.g., 'fhir', 'http', 'jms')"}, arity="1")
    private String camelComponent;
    @CommandLine.Parameters(description={"Fully qualified class name (e.g., 'org.hl7.fhir.r4.model.Patient')"}, arity="1")
    private String fullyQualifiedName;
    @CommandLine.Option(names={"--camel-version"}, description={"Camel version to use"})
    private String camelVersion;
    @CommandLine.Option(names={"--output"}, description={"Output file path (default: stdout)"})
    private String outputFile;
    @CommandLine.Option(names={"--verbose"}, description={"Enable verbose logging"})
    private boolean verbose;
    @CommandLine.Option(names={"--download"}, defaultValue="true", description={"Whether to allow automatic downloading JAR dependencies (over the internet)"})
    boolean download = true;
    @CommandLine.Option(names={"--repos"}, description={"Additional maven repositories (Use commas to separate multiple repositories)"})
    String repositories;

    public CodeSchemaGenerator(CamelJBangMain main) {
        super(main);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Integer doCall() throws Exception {
        try {
            if (this.camelVersion == null) {
                this.camelVersion = new DefaultCamelCatalog().getCatalogVersion();
            }
            if (this.verbose) {
                this.printer().println("Generating JSON Schema for component: " + this.camelComponent);
                this.printer().println("Class: " + this.fullyQualifiedName);
                this.printer().println("Camel version: " + this.camelVersion);
            }
            if (this.camelComponent == null || this.camelComponent.trim().isEmpty()) {
                this.printer().printErr("Error: Camel component name cannot be empty");
                return 4;
            }
            if (this.fullyQualifiedName == null || this.fullyQualifiedName.trim().isEmpty()) {
                this.printer().printErr("Error: Fully qualified class name cannot be empty");
                return 4;
            }
            JacksonModule jacksonModule = new JacksonModule();
            SchemaGeneratorConfig config = this.createSchemaGeneratorConfig(jacksonModule);
            SchemaGenerator generator = new SchemaGenerator(config);
            DependencyDownloaderClassLoader cl = this.getDependencyDownloaderClassLoader(this.camelComponent, this.camelVersion, this.verbose);
            if (cl == null) {
                return 1;
            }
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)cl);
                Class<?> targetClass = this.loadTargetClass((ClassLoader)cl, this.fullyQualifiedName);
                if (targetClass == null) {
                    Integer n = 2;
                    return n;
                }
                JsonNode schema = this.generateSchema(generator, targetClass);
                if (schema == null) {
                    Integer n = 3;
                    return n;
                }
                this.outputSchema(schema);
                if (this.verbose) {
                    this.printer().println("Schema generation completed successfully");
                }
                Integer n = 0;
                return n;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
        catch (Exception e) {
            this.printer().printErr("Unexpected error during schema generation: " + e.getMessage());
            if (!this.verbose) return 4;
            e.printStackTrace();
            return 4;
        }
    }

    private SchemaGeneratorConfig createSchemaGeneratorConfig(JacksonModule jacksonModule) {
        return new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12).with((Module)jacksonModule).with(Option.FLATTENED_ENUMS_FROM_TOSTRING, new Option[0]).without(Option.FIELDS_DERIVED_FROM_ARGUMENTFREE_METHODS, new Option[0]).without(Option.NONSTATIC_NONVOID_NONGETTER_METHODS, new Option[0]).without(Option.NULLABLE_METHOD_RETURN_VALUES_BY_DEFAULT, new Option[0]).without(Option.VOID_METHODS, new Option[0]).without(Option.GETTER_METHODS, new Option[0]).without(Option.FIELDS_DERIVED_FROM_ARGUMENTFREE_METHODS, new Option[0]).without(Option.STATIC_METHODS, new Option[0]).build();
    }

    private DependencyDownloaderClassLoader getDependencyDownloaderClassLoader(String camelComponent, String version, boolean verbose) {
        try {
            List artifacts;
            if (verbose) {
                this.printer().println("Creating dependency downloader class loader...");
            }
            DependencyDownloaderClassLoader cl = new DependencyDownloaderClassLoader(CodeSchemaGenerator.class.getClassLoader());
            MavenDependencyDownloader downloader = new MavenDependencyDownloader();
            downloader.setClassLoader((ClassLoader)cl);
            downloader.setDownload(this.download);
            downloader.setRepositories(this.repositories);
            downloader.start();
            if (verbose) {
                this.printer().println("Downloading artifacts for camel-" + camelComponent + ":" + version);
            }
            if ((artifacts = downloader.downloadArtifacts("org.apache.camel", "camel-" + camelComponent, version, true)) == null || artifacts.isEmpty()) {
                this.printer().printErr("Error: No artifacts found for component 'camel-" + camelComponent + "' version '" + version + "'");
                this.printer().printErr("Please verify that the component name is correct and the version exists.");
                this.printer().printErr("Available components can be found at: https://camel.apache.org/components/");
                return null;
            }
            if (verbose) {
                this.printer().println("Downloaded " + artifacts.size() + " artifact(s)");
                artifacts.forEach(artifact -> this.printer().println("  - " + artifact.getFile().getName()));
            }
            artifacts.forEach(artifact -> cl.addFile(artifact.getFile()));
            return cl;
        }
        catch (Exception e) {
            this.printer().printErr("Error downloading dependencies for component 'camel-" + camelComponent + "':");
            this.printer().printErr("  " + e.getMessage());
            this.printer().printErr(System.lineSeparator());
            this.printer().printErr("Possible causes:");
            this.printer().printErr("  - Component name is incorrect (check spelling)");
            this.printer().printErr("  - Version '" + version + "' does not exist");
            this.printer().printErr("  - Network connectivity issues");
            this.printer().printErr("  - Maven repository is unavailable");
            this.printer().printErr(System.lineSeparator());
            this.printer().printErr("You can find available components at: https://camel.apache.org/components/");
            if (verbose) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private Class<?> loadTargetClass(ClassLoader classLoader, String className) {
        try {
            if (this.verbose) {
                this.printer().println("Loading class: " + className);
            }
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            this.printer().printErr("Error: Class '" + className + "' not found in component dependencies");
            this.printer().printErr(System.lineSeparator());
            this.printer().printErr("Possible causes:");
            this.printer().printErr("  - Class name is incorrect (check spelling and package)");
            this.printer().printErr("  - Class is not part of the '" + this.camelComponent + "' component");
            this.printer().printErr("  - Class is in a different artifact not included as dependency");
            this.printer().printErr(System.lineSeparator());
            this.printer().printErr("To find available classes, you can:");
            this.printer().printErr("  - Check the component documentation");
            this.printer().printErr("  - Browse the Maven artifact at: https://mvnrepository.com/artifact/org/apache/camel/camel-" + this.camelComponent);
            if (this.verbose) {
                e.printStackTrace();
            }
            return null;
        }
        catch (Exception e) {
            this.printer().printErr("Error loading class '" + className + "': " + e.getMessage());
            if (this.verbose) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private JsonNode generateSchema(SchemaGenerator generator, Class<?> targetClass) {
        try {
            if (this.verbose) {
                this.printer().println("Generating schema for class: " + targetClass.getName());
            }
            return generator.generateSchema(targetClass, new Type[0]);
        }
        catch (Exception e) {
            this.printer().printErr("Error generating schema for class '" + targetClass.getName() + "':");
            this.printer().printErr("  " + e.getMessage());
            this.printer().printErr(System.lineSeparator());
            this.printer().printErr("This might be caused by:");
            this.printer().printErr("  - Complex class structure that cannot be serialized");
            this.printer().printErr("  - Missing dependencies for the class");
            this.printer().printErr("  - Circular references in the class hierarchy");
            if (this.verbose) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private void outputSchema(JsonNode schema) throws Exception {
        if (this.outputFile == null || this.outputFile.isEmpty()) {
            this.outputFile = String.valueOf(Paths.get(".", new String[0])) + File.separator + this.fullyQualifiedName + "-schema.json";
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.writerWithDefaultPrettyPrinter().writeValue(new File(this.outputFile), (Object)schema);
        this.printer().println("Schema saved to: " + this.outputFile);
    }
}

