/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.edit;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Stack;
import java.util.function.Supplier;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.edit.CamelNanoLspEditor;
import org.jline.builtins.ClasspathResourceUtil;
import org.jline.builtins.ConfigurationPath;
import org.jline.builtins.Nano;
import org.jline.builtins.Options;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import picocli.CommandLine;

@CommandLine.Command(name="edit", description={"Edit Camel with suggestions and diagnostics"})
public class EditCommand
extends CamelCommand {
    @CommandLine.Parameters(description={"Name of file"}, arity="1", paramLabel="<file>", parameterConsumer=FileConsumer.class)
    private Path filePath;
    private String file;

    public EditCommand(CamelJBangMain main) {
        super(main);
    }

    public Integer doCall() throws Exception {
        Supplier<Path> workDir = () -> Paths.get(System.getProperty("user.dir"), new String[0]);
        try (Terminal terminal = TerminalBuilder.builder().build();){
            Object[] argv = new String[]{this.file};
            Options opt = Options.compile((String[])Nano.usage()).parse(argv);
            if (opt.isSet("help")) {
                throw new Options.HelpException(opt.usage());
            }
            Path currentDir = workDir.get();
            Path appConfig = ClasspathResourceUtil.getResourcePath((String)"/nano/jnanorc", ((Object)((Object)this)).getClass()).getParent();
            ConfigurationPath configPath = new ConfigurationPath(appConfig, null);
            CamelNanoLspEditor edit = new CamelNanoLspEditor(terminal, currentDir, opt, configPath);
            edit.open(opt.args());
            edit.run();
        }
        return 0;
    }

    static class FileConsumer
    extends CamelCommand.ParameterConsumer<EditCommand> {
        FileConsumer() {
        }

        protected void doConsumeParameters(Stack<String> args, EditCommand cmd) {
            cmd.file = args.pop();
        }
    }
}

