/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jbang.console;

import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.impl.console.ConsoleHelper;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.RouteOnDemandReloadStrategy;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="source-dir", group="camel-jbang", displayName="Source Directory", description="Information about Camel JBang source files")
public class SourceDirDevConsole
extends AbstractDevConsole {
    public static final String SOURCE = "source";

    public SourceDirDevConsole() {
        super("camel-jbang", "source-dir", "Source Directory", "Information about Camel JBang source files");
    }

    protected String doCallText(Map<String, Object> options) {
        String path = (String)options.get("CamelHttpPath");
        String subPath = path != null ? StringHelper.after((String)path, (String)"/") : null;
        String source = (String)options.get(SOURCE);
        StringBuilder sb = new StringBuilder();
        RouteOnDemandReloadStrategy reload = (RouteOnDemandReloadStrategy)this.getCamelContext().hasService(RouteOnDemandReloadStrategy.class);
        if (reload != null) {
            File[] files;
            sb.append(String.format("Directory: %s%n", reload.getFolder()));
            File dir = new File(reload.getFolder());
            if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
                sb.append("Files:\n");
                Arrays.sort(files, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
                for (File f : files) {
                    boolean match;
                    boolean skip;
                    boolean bl = skip = f.getName().startsWith(".") || f.isHidden();
                    if (skip) continue;
                    boolean bl2 = match = subPath == null || f.getName().startsWith(subPath) || f.getName().endsWith(subPath) || PatternHelper.matchPattern((String)f.getName(), (String)subPath);
                    if (!match) continue;
                    long size = f.length();
                    long ts = f.lastModified();
                    String age = ts > 0L ? TimeUtils.printSince((long)ts) : "n/a";
                    sb.append(String.format("    %s (size: %d age: %s)%n", f.getName(), size, age));
                    if (!"true".equals(source)) continue;
                    StringBuilder code = new StringBuilder();
                    try {
                        String t;
                        LineNumberReader reader = new LineNumberReader(new FileReader(f));
                        int i = 0;
                        do {
                            if ((t = reader.readLine()) == null) continue;
                            code.append(String.format("\n    #%s %s", ++i, t));
                        } while (t != null);
                        IOHelper.close((Closeable)reader);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (code.isEmpty()) continue;
                    sb.append("    ").append("-".repeat(40));
                    sb.append((CharSequence)code);
                    sb.append("\n\n");
                }
            }
        }
        return sb.toString();
    }

    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        String path = (String)options.get("CamelHttpPath");
        String subPath = path != null ? StringHelper.after((String)path, (String)"/") : null;
        String source = (String)options.get(SOURCE);
        JsonObject root = new JsonObject();
        RouteOnDemandReloadStrategy reload = (RouteOnDemandReloadStrategy)this.getCamelContext().hasService(RouteOnDemandReloadStrategy.class);
        if (reload != null) {
            File[] files;
            root.put((Object)"dir", (Object)reload.getFolder());
            File dir = new File(reload.getFolder());
            if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
                Arrays.sort(files, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
                JsonArray arr = new JsonArray();
                root.put((Object)"files", (Object)arr);
                for (File f : files) {
                    boolean match;
                    boolean skip;
                    boolean bl = skip = f.getName().startsWith(".") || f.isHidden();
                    if (skip) continue;
                    boolean bl2 = match = subPath == null || f.getName().startsWith(subPath) || f.getName().endsWith(subPath) || PatternHelper.matchPattern((String)f.getName(), (String)subPath);
                    if (!match) continue;
                    JsonObject jo = new JsonObject();
                    jo.put((Object)"name", (Object)f.getName());
                    jo.put((Object)"size", (Object)f.length());
                    jo.put((Object)"lastModified", (Object)f.lastModified());
                    if ("true".equals(source)) {
                        try {
                            List code = ConsoleHelper.loadSourceAsJson((Reader)new FileReader(f), null);
                            if (code != null) {
                                jo.put((Object)"code", (Object)code);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    arr.add((Object)jo);
                }
            }
        }
        return root;
    }
}

