/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.TypeConverterAware;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FallbackTypeConverter
implements TypeConverter,
TypeConverterAware {
    private static final transient Log LOG = LogFactory.getLog(FallbackTypeConverter.class);
    private TypeConverter parentTypeConverter;
    private boolean prettyPrint = true;

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setTypeConverter(TypeConverter parentTypeConverter) {
        this.parentTypeConverter = parentTypeConverter;
    }

    public <T> T convertTo(Class<T> type, Object value) {
        try {
            if (this.isJaxbType(type)) {
                return this.unmarshall(type, value);
            }
            if (value != null && this.isJaxbType(value.getClass())) {
                return this.marshall(type, value);
            }
            return null;
        }
        catch (JAXBException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    protected <T> boolean isJaxbType(Class<T> type) {
        XmlRootElement element = type.getAnnotation(XmlRootElement.class);
        boolean jaxbType = element != null;
        return jaxbType;
    }

    protected <T> T unmarshall(Class<T> type, Object value) throws JAXBException {
        Object unmarshalled;
        JAXBContext context = this.createContext(type);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (this.parentTypeConverter != null) {
            InputStream inputStream = (InputStream)this.parentTypeConverter.convertTo(InputStream.class, value);
            if (inputStream != null) {
                Object unmarshalled2 = unmarshaller.unmarshal(inputStream);
                return type.cast(unmarshalled2);
            }
            Reader reader = (Reader)this.parentTypeConverter.convertTo(Reader.class, value);
            if (reader != null) {
                Object unmarshalled3 = unmarshaller.unmarshal(reader);
                return type.cast(unmarshalled3);
            }
            Source source = (Source)this.parentTypeConverter.convertTo(Source.class, value);
            if (source != null) {
                Object unmarshalled4 = unmarshaller.unmarshal(source);
                return type.cast(unmarshalled4);
            }
        }
        if (value instanceof String) {
            value = new StringReader((String)value);
        }
        if (value instanceof InputStream) {
            unmarshalled = unmarshaller.unmarshal((InputStream)value);
            return type.cast(unmarshalled);
        }
        if (value instanceof Reader) {
            unmarshalled = unmarshaller.unmarshal((Reader)value);
            return type.cast(unmarshalled);
        }
        return null;
    }

    protected <T> T marshall(Class<T> type, Object value) throws JAXBException {
        if (this.parentTypeConverter != null) {
            JAXBContext context = this.createContext(value.getClass());
            JAXBSource source = new JAXBSource(context, value);
            Object answer = this.parentTypeConverter.convertTo(type, (Object)source);
            if (answer == null) {
                StringWriter buffer = new StringWriter();
                Marshaller marshaller = context.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)(this.isPrettyPrint() ? Boolean.TRUE : Boolean.FALSE));
                marshaller.marshal(value, (Writer)buffer);
                return (T)this.parentTypeConverter.convertTo(type, (Object)buffer.toString());
            }
            return (T)answer;
        }
        return null;
    }

    protected <T> JAXBContext createContext(Class<T> type) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{type});
        return context;
    }
}

